/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import swim.codec.Input;
import swim.codec.Parser;
import swim.json.JsonParser;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;

final class JsonFormParser<T>
extends Parser<T> {
    final JsonParser<Item, Value> json;
    final Form<T> form;
    final Parser<Value> parser;

    JsonFormParser(JsonParser<Item, Value> json, Form<T> form, Parser<Value> parser) {
        this.json = json;
        this.form = form;
        this.parser = parser;
    }

    JsonFormParser(JsonParser<Item, Value> json, Form<T> form) {
        this(json, form, null);
    }

    public Parser<T> feed(Input input) {
        return JsonFormParser.parse(input, this.json, this.form, this.parser);
    }

    static <T> Parser<T> parse(Input input, JsonParser<Item, Value> json, Form<T> form, Parser<Value> parser) {
        if ((parser = parser == null ? json.parseValue(input) : parser.feed(input)).isDone()) {
            Value value = (Value)parser.bind();
            return Parser.done((Object)form.cast((Item)value));
        }
        if (parser.isError()) {
            return parser.asError();
        }
        return new JsonFormParser<T>(json, form, (Parser<Value>)parser);
    }

    static <T> Parser<T> parse(Input input, JsonParser<Item, Value> json, Form<T> form) {
        return JsonFormParser.parse(input, json, form, null);
    }
}

