/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import java.util.Iterator;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.json.JsonWriter;
import swim.structure.Absent;
import swim.structure.Attr;
import swim.structure.Bool;
import swim.structure.Data;
import swim.structure.Extant;
import swim.structure.Field;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.Value;

public class JsonStructureWriter
extends JsonWriter<Item, Value> {
    @Override
    public Iterator<Item> items(Item item) {
        return item.iterator();
    }

    @Override
    public Item item(Value value) {
        return value;
    }

    @Override
    public Value key(Item item) {
        return item.key();
    }

    @Override
    public Value value(Item item) {
        return item.toValue();
    }

    @Override
    public Writer<?, ?> writeItem(Output<?> output, Item item) {
        if (item instanceof Field) {
            if (item instanceof Attr) {
                Attr that = (Attr)item;
                return this.writeField(output, Text.from((String)("@" + that.key().stringValue())), that.value());
            }
            if (item instanceof Slot) {
                Slot that = (Slot)item;
                if (that.key() instanceof Text) {
                    return this.writeField(output, that.key(), that.value());
                }
                return this.writeValue(output, (Value)Record.of((Object[])new Object[]{Slot.of((String)"$key", (Value)that.key()), Slot.of((String)"$value", (Value)that.value())}));
            }
        } else if (item instanceof Value) {
            return this.writeValue(output, (Value)item);
        }
        return Writer.error((Throwable)new WriterException("No JSON serialization for " + item));
    }

    @Override
    public Writer<?, ?> writeField(Output<?> output, Item item, int index) {
        if (item instanceof Field) {
            if (item instanceof Attr) {
                Attr that = (Attr)item;
                return this.writeField(output, Text.from((String)("@" + that.key().stringValue())), that.value());
            }
            if (item instanceof Slot) {
                Slot that = (Slot)item;
                if (that.key() instanceof Text) {
                    return this.writeField(output, that.key(), that.value());
                }
                return this.writeField(output, Text.from((String)("$" + index)), Record.of((Object[])new Object[]{Slot.of((String)"$key", (Value)that.key()), Slot.of((String)"$value", (Value)that.value())}));
            }
        } else if (item instanceof Value) {
            return this.writeItem(output, (Item)Slot.of((Value)Text.from((String)("$" + index)), (Value)((Value)item)));
        }
        return Writer.error((Throwable)new WriterException("No JSON serialization for " + item));
    }

    @Override
    public Writer<?, ?> writeValue(Output<?> output, Item item, int index) {
        if (item instanceof Field) {
            return this.writeValue(output, item.toValue());
        }
        if (item instanceof Value) {
            return this.writeValue(output, (Value)item);
        }
        return Writer.error((Throwable)new WriterException("No JSON serialization for " + item));
    }

    @Override
    public Writer<?, ?> writeValue(Output<?> output, Value value) {
        if (value instanceof Record) {
            Record that = (Record)value;
            if (that.isArray()) {
                return this.writeArray(output, that);
            }
            return this.writeObject(output, that);
        }
        if (value instanceof Data) {
            Data that = (Data)value;
            return this.writeData(output, that.asByteBuffer());
        }
        if (value instanceof Text) {
            Text that = (Text)value;
            return this.writeText(output, that.stringValue());
        }
        if (value instanceof Num) {
            Num that = (Num)value;
            if (that.isUint32()) {
                return this.writeUint32(output, that.intValue());
            }
            if (that.isUint64()) {
                return this.writeUint64(output, that.longValue());
            }
            if (that.isValidInt()) {
                return this.writeNum(output, that.intValue());
            }
            if (that.isValidLong()) {
                return this.writeNum(output, that.longValue());
            }
            if (that.isValidFloat()) {
                return this.writeNum(output, that.floatValue());
            }
            if (that.isValidDouble()) {
                return this.writeNum(output, that.doubleValue());
            }
            if (that.isValidInteger()) {
                return this.writeNum(output, that.integerValue());
            }
        } else {
            if (value instanceof Bool) {
                Bool that = (Bool)value;
                return this.writeBool(output, that.booleanValue());
            }
            if (value instanceof Extant) {
                return this.writeNull(output);
            }
            if (value instanceof Absent) {
                return this.writeUndefined(output);
            }
        }
        return Writer.error((Throwable)new WriterException("No JSON serialization for " + value));
    }
}

