/*
 * Decompiled with CFR 0.152.
 */
package swim.json;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Iterator;
import swim.codec.Base10;
import swim.codec.Base16;
import swim.codec.Output;
import swim.codec.Unicode;
import swim.codec.Writer;
import swim.json.ArrayWriter;
import swim.json.DataWriter;
import swim.json.FieldWriter;
import swim.json.ObjectWriter;
import swim.json.StringWriter;

public abstract class JsonWriter<I, V> {
    public abstract Iterator<I> items(I var1);

    public abstract I item(V var1);

    public abstract V key(I var1);

    public abstract V value(I var1);

    public abstract Writer<?, ?> writeItem(Output<?> var1, I var2);

    public abstract Writer<?, ?> writeField(Output<?> var1, I var2, int var3);

    public abstract Writer<?, ?> writeValue(Output<?> var1, I var2, int var3);

    public abstract Writer<?, ?> writeValue(Output<?> var1, V var2);

    public Writer<?, ?> writeField(Output<?> output, V key, V value) {
        return FieldWriter.write(output, this, key, value);
    }

    public Writer<?, ?> writeArray(Output<?> output, I item) {
        return ArrayWriter.write(output, this, this.items(item));
    }

    public Writer<?, ?> writeObject(Output<?> output, I item) {
        return ObjectWriter.write(output, this, this.items(item));
    }

    public Writer<?, ?> writeData(Output<?> output, ByteBuffer value) {
        if (value != null) {
            return DataWriter.write(output, value);
        }
        return Unicode.writeString(output, (Object)"\"\"");
    }

    public Writer<?, ?> writeText(Output<?> output, String value) {
        return StringWriter.write(output, value);
    }

    public Writer<?, ?> writeNum(Output<?> output, int value) {
        return Base10.writeInt(output, (int)value);
    }

    public Writer<?, ?> writeNum(Output<?> output, long value) {
        return Base10.writeLong(output, (long)value);
    }

    public Writer<?, ?> writeNum(Output<?> output, float value) {
        return Base10.writeFloat(output, (float)value);
    }

    public Writer<?, ?> writeNum(Output<?> output, double value) {
        return Base10.writeDouble(output, (double)value);
    }

    public Writer<?, ?> writeNum(Output<?> output, BigInteger value) {
        return Unicode.writeString(output, (Object)value);
    }

    public Writer<?, ?> writeUint32(Output<?> output, int value) {
        return Base16.lowercase().writeIntLiteral(output, value, 8);
    }

    public Writer<?, ?> writeUint64(Output<?> output, long value) {
        return Base16.lowercase().writeLongLiteral(output, value, 16);
    }

    public Writer<?, ?> writeBool(Output<?> output, boolean value) {
        return Unicode.writeString(output, (Object)(value ? "true" : "false"));
    }

    public Writer<?, ?> writeNull(Output<?> output) {
        return Unicode.writeString(output, (Object)"null");
    }

    public Writer<?, ?> writeUndefined(Output<?> output) {
        return Unicode.writeString(output, (Object)"undefined");
    }
}

