/*
 * Decompiled with CFR 0.152.
 */
package swim.kernel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.kernel.Kernel;
import swim.kernel.KernelException;
import swim.recon.Recon;
import swim.structure.Item;
import swim.structure.Value;

public final class KernelLoader {
    private KernelLoader() {
    }

    public static Kernel loadKernel() {
        return KernelLoader.loadKernel(KernelLoader.class.getClassLoader());
    }

    public static Kernel loadKernel(ClassLoader classLoader) {
        try {
            Value kernelConfig = KernelLoader.loadConfig(classLoader);
            if (kernelConfig == null) {
                kernelConfig = Value.absent();
            }
            return KernelLoader.loadKernelStack(classLoader, kernelConfig);
        }
        catch (IOException cause) {
            throw new KernelException(cause);
        }
    }

    public static Kernel loadKernelStack(ClassLoader classLoader, Value kernelConfig) {
        Kernel kernelStack = null;
        int n = kernelConfig.length();
        for (int i = 0; i < n; ++i) {
            Item moduleConfig = kernelConfig.getItem(i);
            Kernel kernelModule = KernelLoader.loadKernelModule(classLoader, moduleConfig.toValue());
            if (kernelModule == null) continue;
            kernelStack = kernelStack == null ? kernelModule : kernelStack.injectKernel(kernelModule);
        }
        return kernelStack;
    }

    public static Kernel loadKernelModule(ClassLoader classLoader, Value moduleConfig) {
        Kernel kernel;
        block7: {
            kernel = null;
            Value header = moduleConfig.getAttr("kernel");
            String kernelClassName = header.get("class").stringValue(null);
            if (kernelClassName != null) {
                try {
                    Class<?> kernelClass = Class.forName(kernelClassName, true, classLoader);
                    try {
                        Method kernelFromValueMethod = kernelClass.getMethod("fromValue", Value.class);
                        if ((kernelFromValueMethod.getModifiers() & 8) != 0) {
                            kernelFromValueMethod.setAccessible(true);
                            kernel = (Kernel)kernelFromValueMethod.invoke(null, moduleConfig);
                        }
                    }
                    catch (NoSuchMethodException kernelFromValueMethod) {
                        // empty catch block
                    }
                    if (kernel == null) {
                        Constructor<?> kernelConstructor = kernelClass.getConstructor(new Class[0]);
                        kernelConstructor.setAccessible(true);
                        kernel = (Kernel)kernelConstructor.newInstance(new Object[0]);
                    }
                }
                catch (ReflectiveOperationException cause) {
                    if (header.get("optional").booleanValue(false)) break block7;
                    throw new KernelException("failed to load required kernel class: " + kernelClassName, cause);
                }
            }
        }
        return kernel;
    }

    public static Value loadConfig() throws IOException {
        return KernelLoader.loadConfig(KernelLoader.class.getClassLoader());
    }

    public static Value loadConfig(ClassLoader classLoader) throws IOException {
        Value configValue = KernelLoader.loadConfigFile();
        if (configValue == null) {
            configValue = KernelLoader.loadConfigResource(classLoader);
        }
        return configValue;
    }

    public static Value loadConfigFile() throws IOException {
        File configFile;
        Value configValue = null;
        String configPath = System.getProperty("swim.config.file");
        if (configPath == null) {
            configPath = System.getProperty("swim.config");
        }
        if (configPath != null && (configFile = new File(configPath)).exists()) {
            configValue = KernelLoader.loadConfigFile(configFile);
        }
        return configValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Value loadConfigFile(File configFile) throws IOException {
        Value configValue = null;
        FileInputStream configInput = null;
        try {
            configInput = new FileInputStream(configFile);
            if (configInput != null) {
                configValue = KernelLoader.parseConfigValue(configInput);
            }
        }
        finally {
            try {
                if (configInput != null) {
                    configInput.close();
                }
            }
            catch (IOException iOException) {}
        }
        return configValue;
    }

    public static Value loadConfigResource(ClassLoader classLoader) throws IOException {
        Value configValue = null;
        String configResource = System.getProperty("swim.config.resource");
        if (configResource == null) {
            configResource = System.getProperty("swim.config");
        }
        if (configResource != null) {
            configValue = KernelLoader.loadConfigResource(classLoader, configResource);
        }
        return configValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Value loadConfigResource(ClassLoader classLoader, String configResource) throws IOException {
        Value configValue = null;
        InputStream configInput = null;
        try {
            configInput = classLoader.getResourceAsStream(configResource);
            if (configInput != null) {
                configValue = KernelLoader.parseConfigValue(configInput);
            }
        }
        finally {
            try {
                if (configInput != null) {
                    configInput.close();
                }
            }
            catch (IOException iOException) {}
        }
        return configValue;
    }

    public static Value parseConfigValue(InputStream configInput) throws IOException {
        return (Value)Utf8.read((InputStream)configInput, (Parser)Recon.structureParser().blockParser());
    }
}

