/*
 * Decompiled with CFR 0.152.
 */
package swim.kernel;

import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.agent.AgentRoute;
import swim.api.auth.Authenticator;
import swim.api.auth.AuthenticatorDef;
import swim.api.plane.Plane;
import swim.api.plane.PlaneDef;
import swim.api.plane.PlaneFactory;
import swim.api.policy.Policy;
import swim.api.service.Service;
import swim.api.service.ServiceDef;
import swim.api.service.ServiceFactory;
import swim.api.space.Space;
import swim.api.space.SpaceDef;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Schedule;
import swim.concurrent.ScheduleDef;
import swim.concurrent.Stage;
import swim.concurrent.StageDef;
import swim.io.IpService;
import swim.io.IpServiceRef;
import swim.io.IpSettings;
import swim.io.IpSocket;
import swim.io.IpSocketRef;
import swim.io.Station;
import swim.kernel.Kernel;
import swim.kernel.KernelBinding;
import swim.kernel.KernelContext;
import swim.store.StoreBinding;
import swim.store.StoreDef;
import swim.structure.Item;
import swim.system.CellAddress;
import swim.system.EdgeAddress;
import swim.system.EdgeBinding;
import swim.system.HostAddress;
import swim.system.HostBinding;
import swim.system.HostDef;
import swim.system.LaneAddress;
import swim.system.LaneBinding;
import swim.system.LaneDef;
import swim.system.LinkBinding;
import swim.system.LogDef;
import swim.system.MeshAddress;
import swim.system.MeshBinding;
import swim.system.MeshDef;
import swim.system.Metric;
import swim.system.NodeAddress;
import swim.system.NodeBinding;
import swim.system.NodeDef;
import swim.system.PartAddress;
import swim.system.PartBinding;
import swim.system.PartDef;
import swim.system.PolicyDef;
import swim.util.Log;
import swim.web.WebRequest;
import swim.web.WebResponse;

public abstract class KernelProxy
implements KernelBinding,
KernelContext {
    protected KernelBinding kernelBinding = null;
    protected KernelContext kernelContext = null;
    protected volatile int status = 0;
    protected static final int STARTED = 1;
    protected static final AtomicIntegerFieldUpdater<KernelProxy> STATUS = AtomicIntegerFieldUpdater.newUpdater(KernelProxy.class, "status");

    @Override
    public final KernelBinding kernelWrapper() {
        KernelBinding kernelBinding = this.kernelBinding;
        return kernelBinding != null ? kernelBinding.kernelWrapper() : this;
    }

    @Override
    public final KernelBinding kernelBinding() {
        return this.kernelBinding;
    }

    @Override
    public void setKernelBinding(KernelBinding kernelBinding) {
        this.kernelBinding = kernelBinding;
    }

    @Override
    public final KernelContext kernelContext() {
        return this.kernelContext;
    }

    @Override
    public void setKernelContext(KernelContext kernelContext) {
        this.kernelContext = kernelContext;
    }

    @Override
    public <T> T unwrapKernel(Class<T> kernelClass) {
        if (kernelClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? (T)kernelContext.unwrapKernel(kernelClass) : null;
    }

    @Override
    public abstract double kernelPriority();

    @Override
    public Kernel injectKernel(Kernel kernel) {
        if (this.kernelPriority() < kernel.kernelPriority()) {
            this.setKernelBinding((KernelBinding)kernel);
            ((KernelBinding)kernel).setKernelContext(this);
            return kernel;
        }
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext == null) {
            ((KernelContext)kernel).setKernelBinding(this);
            this.setKernelContext((KernelContext)kernel);
        } else {
            kernel = kernelContext.injectKernel(kernel);
            ((KernelContext)kernel).setKernelBinding(this);
            this.setKernelContext((KernelContext)kernel);
        }
        return this;
    }

    @Override
    public FingerTrieSeq<Kernel> modules() {
        KernelContext kernelContext = this.kernelContext;
        FingerTrieSeq modules = kernelContext != null ? kernelContext.modules() : FingerTrieSeq.empty();
        modules = modules.prepended((Object)this);
        return modules;
    }

    @Override
    public final boolean isStarted() {
        return (STATUS.get(this) & 1) != 0;
    }

    @Override
    public Stage stage() {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.stage() : null;
    }

    @Override
    public Station station() {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.station() : null;
    }

    @Override
    public LogDef defineLog(Item logConfig) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.defineLog(logConfig) : null;
    }

    @Override
    public Log createLog(LogDef logDef) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createLog(logDef) : null;
    }

    @Override
    public Log createLog(CellAddress cellAddress) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createLog(cellAddress) : null;
    }

    @Override
    public Log injectLog(Log log) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.injectLog(log) : log;
    }

    @Override
    public PolicyDef definePolicy(Item policyConfig) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.definePolicy(policyConfig) : null;
    }

    @Override
    public Policy createPolicy(PolicyDef policyDef) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createPolicy(policyDef) : null;
    }

    @Override
    public Policy createPolicy(CellAddress cellAddress) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createPolicy(cellAddress) : null;
    }

    @Override
    public Policy injectPolicy(Policy policy) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.injectPolicy(policy) : policy;
    }

    @Override
    public ScheduleDef defineSchedule(Item scheduleConfig) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.defineSchedule(scheduleConfig) : null;
    }

    @Override
    public Schedule createSchedule(ScheduleDef scheduleDef, Stage stage) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createSchedule(scheduleDef, stage) : null;
    }

    @Override
    public Schedule injectSchedule(Schedule schedule) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.injectSchedule(schedule) : schedule;
    }

    @Override
    public StageDef defineStage(Item stageConfig) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.defineStage(stageConfig) : null;
    }

    @Override
    public Stage createStage(StageDef stageDef) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createStage(stageDef) : null;
    }

    @Override
    public Stage createStage(CellAddress cellAddress) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createStage(cellAddress) : null;
    }

    @Override
    public Stage injectStage(Stage stage) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.injectStage(stage) : stage;
    }

    @Override
    public StoreDef defineStore(Item storeConfig) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.defineStore(storeConfig) : null;
    }

    @Override
    public StoreBinding createStore(StoreDef storeDef, ClassLoader classLoader) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createStore(storeDef, classLoader) : null;
    }

    @Override
    public StoreBinding createStore(CellAddress cellAddress) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createStore(cellAddress) : null;
    }

    @Override
    public StoreBinding injectStore(StoreBinding store) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.injectStore(store) : store;
    }

    @Override
    public AuthenticatorDef defineAuthenticator(Item authenticatorConfig) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.defineAuthenticator(authenticatorConfig) : null;
    }

    @Override
    public Authenticator createAuthenticator(AuthenticatorDef authenticatorDef, ClassLoader classLoader) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createAuthenticator(authenticatorDef, classLoader) : null;
    }

    @Override
    public Authenticator injectAuthenticator(Authenticator authenticator) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.injectAuthenticator(authenticator) : authenticator;
    }

    @Override
    public IpSettings ipSettings() {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.ipSettings() : null;
    }

    @Override
    public IpServiceRef bindTcp(InetSocketAddress localAddress, IpService service, IpSettings ipSettings) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.bindTcp(localAddress, service, ipSettings) : null;
    }

    @Override
    public IpServiceRef bindTls(InetSocketAddress localAddress, IpService service, IpSettings ipSettings) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.bindTls(localAddress, service, ipSettings) : null;
    }

    @Override
    public IpSocketRef connectTcp(InetSocketAddress remoteAddress, IpSocket socket, IpSettings ipSettings) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.connectTcp(remoteAddress, socket, ipSettings) : null;
    }

    @Override
    public IpSocketRef connectTls(InetSocketAddress remoteAddress, IpSocket socket, IpSettings ipSettings) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.connectTls(remoteAddress, socket, ipSettings) : null;
    }

    @Override
    public Service getService(String serviceName) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.getService(serviceName) : null;
    }

    @Override
    public ServiceDef defineService(Item serviceConfig) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.defineService(serviceConfig) : null;
    }

    @Override
    public ServiceFactory<?> createServiceFactory(ServiceDef serviceDef, ClassLoader classLoader) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createServiceFactory(serviceDef, classLoader) : null;
    }

    @Override
    public Service injectService(Service service) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.injectService(service) : service;
    }

    @Override
    public <S extends Service> S openService(String serviceName, ServiceFactory<S> serviceFactory) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? (S)kernelContext.openService(serviceName, serviceFactory) : null;
    }

    @Override
    public WebResponse routeRequest(WebRequest request) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.routeRequest(request) : request.reject();
    }

    @Override
    public Space getSpace(String spaceName) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.getSpace(spaceName) : null;
    }

    @Override
    public SpaceDef defineSpace(Item spaceConfig) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.defineSpace(spaceConfig) : null;
    }

    @Override
    public Space openSpace(SpaceDef spaceDef) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.openSpace(spaceDef) : null;
    }

    @Override
    public PlaneDef definePlane(Item planeConfig) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.definePlane(planeConfig) : null;
    }

    @Override
    public PlaneFactory<?> createPlaneFactory(PlaneDef planeDef, ClassLoader classLoader) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createPlaneFactory(planeDef, classLoader) : null;
    }

    @Override
    public <P extends Plane> PlaneFactory<P> createPlaneFactory(Class<? extends P> planeClass) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createPlaneFactory(planeClass) : null;
    }

    @Override
    public Plane injectPlane(Plane plane) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.injectPlane(plane) : plane;
    }

    @Override
    public AgentDef defineAgent(Item agentConfig) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.defineAgent(agentConfig) : null;
    }

    @Override
    public AgentFactory<?> createAgentFactory(AgentDef agentDef, ClassLoader classLoader) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createAgentFactory(agentDef, classLoader) : null;
    }

    @Override
    public AgentFactory<?> createAgentFactory(NodeBinding node, AgentDef agentDef) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createAgentFactory(node, agentDef) : null;
    }

    @Override
    public <A extends Agent> AgentFactory<A> createAgentFactory(Class<? extends A> agentClass) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createAgentFactory(agentClass) : null;
    }

    @Override
    public <A extends Agent> AgentFactory<A> createAgentFactory(NodeBinding node, Class<? extends A> agentClass) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createAgentFactory(node, agentClass) : null;
    }

    @Override
    public <A extends Agent> AgentRoute<A> createAgentRoute(EdgeBinding edge, Class<? extends A> agentClass) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createAgentRoute(edge, agentClass) : null;
    }

    @Override
    public void openAgents(NodeBinding node) {
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.openAgents(node);
        }
    }

    @Override
    public void openLanes(NodeBinding node) {
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.openLanes(node);
        }
    }

    @Override
    public EdgeBinding createEdge(EdgeAddress edgeAddress) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createEdge(edgeAddress) : null;
    }

    @Override
    public EdgeBinding injectEdge(EdgeAddress edgeAddress, EdgeBinding edge) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.injectEdge(edgeAddress, edge) : edge;
    }

    @Override
    public void openMetaEdge(EdgeBinding edge, NodeBinding metaEdge) {
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.openMetaEdge(edge, metaEdge);
        }
    }

    @Override
    public MeshDef defineMesh(Item meshConfig) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.defineMesh(meshConfig) : null;
    }

    @Override
    public MeshDef getMeshDef(MeshAddress meshAddress) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.getMeshDef(meshAddress) : null;
    }

    @Override
    public MeshBinding createMesh(EdgeBinding edge, MeshDef meshDef) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createMesh(edge, meshDef) : null;
    }

    @Override
    public MeshBinding createMesh(MeshAddress meshAddress) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createMesh(meshAddress) : null;
    }

    @Override
    public MeshBinding injectMesh(MeshAddress meshAddress, MeshBinding mesh) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.injectMesh(meshAddress, mesh) : mesh;
    }

    @Override
    public void openMetaMesh(MeshBinding mesh, NodeBinding metaMesh) {
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.openMetaMesh(mesh, metaMesh);
        }
    }

    @Override
    public PartDef definePart(Item partConfig) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.definePart(partConfig) : null;
    }

    @Override
    public PartDef getPartDef(PartAddress partAddress) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.getPartDef(partAddress) : null;
    }

    @Override
    public PartBinding createPart(MeshBinding mesh, PartDef partDef) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createPart(mesh, partDef) : null;
    }

    @Override
    public PartBinding createPart(PartAddress partAddress) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createPart(partAddress) : null;
    }

    @Override
    public PartBinding injectPart(PartAddress partAddress, PartBinding part) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.injectPart(partAddress, part) : part;
    }

    @Override
    public void openMetaPart(PartBinding part, NodeBinding metaPart) {
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.openMetaPart(part, metaPart);
        }
    }

    @Override
    public HostDef defineHost(Item hostConfig) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.defineHost(hostConfig) : null;
    }

    @Override
    public HostDef getHostDef(HostAddress hostAddress) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.getHostDef(hostAddress) : null;
    }

    @Override
    public HostBinding createHost(PartBinding part, HostDef hostDef) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createHost(part, hostDef) : null;
    }

    @Override
    public HostBinding createHost(HostAddress hostAddress) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createHost(hostAddress) : null;
    }

    @Override
    public HostBinding injectHost(HostAddress hostAddress, HostBinding host) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.injectHost(hostAddress, host) : host;
    }

    @Override
    public void openMetaHost(HostBinding host, NodeBinding metaHost) {
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.openMetaHost(host, metaHost);
        }
    }

    @Override
    public NodeDef defineNode(Item nodeConfig) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.defineNode(nodeConfig) : null;
    }

    @Override
    public NodeDef getNodeDef(NodeAddress nodeAddress) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.getNodeDef(nodeAddress) : null;
    }

    @Override
    public NodeBinding createNode(HostBinding host, NodeDef nodeDef) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createNode(host, nodeDef) : null;
    }

    @Override
    public NodeBinding createNode(NodeAddress nodeAddress) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createNode(nodeAddress) : null;
    }

    @Override
    public NodeBinding injectNode(NodeAddress nodeAddress, NodeBinding node) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.injectNode(nodeAddress, node) : node;
    }

    @Override
    public void openMetaNode(NodeBinding node, NodeBinding metaNode) {
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.openMetaNode(node, metaNode);
        }
    }

    @Override
    public LaneDef defineLane(Item laneConfig) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.defineLane(laneConfig) : null;
    }

    @Override
    public LaneDef getLaneDef(LaneAddress laneAddress) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.getLaneDef(laneAddress) : null;
    }

    @Override
    public LaneBinding createLane(NodeBinding node, LaneDef laneDef) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createLane(node, laneDef) : null;
    }

    @Override
    public LaneBinding createLane(LaneAddress laneAddress) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.createLane(laneAddress) : null;
    }

    @Override
    public LaneBinding injectLane(LaneAddress laneAddress, LaneBinding lane) {
        KernelContext kernelContext = this.kernelContext;
        return kernelContext != null ? kernelContext.injectLane(laneAddress, lane) : lane;
    }

    @Override
    public void openMetaLane(LaneBinding lane, NodeBinding metaLane) {
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.openMetaLane(lane, metaLane);
        }
    }

    @Override
    public void openMetaUplink(LinkBinding uplink, NodeBinding metaUplink) {
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.openMetaUplink(uplink, metaUplink);
        }
    }

    @Override
    public void openMetaDownlink(LinkBinding downlink, NodeBinding metaDownlink) {
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.openMetaDownlink(downlink, metaDownlink);
        }
    }

    @Override
    public void reportDown(Metric metric) {
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.reportDown(metric);
        }
    }

    public void trace(Object message) {
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.trace(message);
        }
    }

    public void debug(Object message) {
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.debug(message);
        }
    }

    public void info(Object message) {
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.info(message);
        }
    }

    public void warn(Object message) {
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.warn(message);
        }
    }

    public void error(Object message) {
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.error(message);
        }
    }

    public void fail(Object message) {
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.fail(message);
        }
    }

    @Override
    public void start() {
        block3: {
            KernelContext kernelContext;
            int newStatus;
            int oldStatus;
            while (!STATUS.compareAndSet(this, oldStatus = STATUS.get(this), newStatus = oldStatus | 1)) {
            }
            if ((oldStatus & 1) == 0) {
                this.willStart();
            }
            if ((kernelContext = this.kernelContext) != null) {
                kernelContext.start();
            }
            if ((oldStatus & 1) != 0) break block3;
            this.didStart();
        }
    }

    @Override
    public void stop() {
        block3: {
            KernelContext kernelContext;
            int newStatus;
            int oldStatus;
            while (!STATUS.compareAndSet(this, oldStatus = STATUS.get(this), newStatus = oldStatus & 0xFFFFFFFE)) {
            }
            if ((oldStatus & 1) != 0) {
                this.willStop();
            }
            if ((kernelContext = this.kernelContext) != null) {
                kernelContext.stop();
            }
            if ((oldStatus & 1) == 0) break block3;
            this.didStop();
        }
    }

    @Override
    public void run() {
        this.start();
        KernelContext kernelContext = this.kernelContext;
        if (kernelContext != null) {
            kernelContext.run();
        }
    }

    protected void willStart() {
    }

    protected void didStart() {
    }

    protected void willStop() {
    }

    protected void didStop() {
    }
}

