/*
 * Decompiled with CFR 0.152.
 */
package swim.kernel;

import java.net.InetSocketAddress;
import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.agent.AgentRoute;
import swim.api.auth.Authenticator;
import swim.api.auth.AuthenticatorDef;
import swim.api.plane.Plane;
import swim.api.plane.PlaneDef;
import swim.api.plane.PlaneFactory;
import swim.api.policy.Policy;
import swim.api.service.Service;
import swim.api.service.ServiceDef;
import swim.api.service.ServiceFactory;
import swim.api.space.Space;
import swim.api.space.SpaceDef;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Schedule;
import swim.concurrent.ScheduleDef;
import swim.concurrent.Stage;
import swim.concurrent.StageDef;
import swim.io.IpInterface;
import swim.io.IpService;
import swim.io.IpServiceRef;
import swim.io.IpSettings;
import swim.io.IpSocket;
import swim.io.IpSocketRef;
import swim.io.Station;
import swim.kernel.Kernel;
import swim.kernel.KernelBinding;
import swim.store.StoreBinding;
import swim.store.StoreDef;
import swim.structure.Item;
import swim.system.CellAddress;
import swim.system.EdgeAddress;
import swim.system.EdgeBinding;
import swim.system.HostAddress;
import swim.system.HostBinding;
import swim.system.HostDef;
import swim.system.LaneAddress;
import swim.system.LaneBinding;
import swim.system.LaneDef;
import swim.system.LinkBinding;
import swim.system.LogDef;
import swim.system.MeshAddress;
import swim.system.MeshBinding;
import swim.system.MeshDef;
import swim.system.Metric;
import swim.system.NodeAddress;
import swim.system.NodeBinding;
import swim.system.NodeDef;
import swim.system.PartAddress;
import swim.system.PartBinding;
import swim.system.PartDef;
import swim.system.PolicyDef;
import swim.util.Log;
import swim.web.WebRequest;
import swim.web.WebResponse;

public interface KernelContext
extends Kernel,
IpInterface,
Log {
    public KernelBinding kernelWrapper();

    public KernelBinding kernelBinding();

    public void setKernelBinding(KernelBinding var1);

    public FingerTrieSeq<Kernel> modules();

    public Stage stage();

    public Station station();

    public LogDef defineLog(Item var1);

    public Log createLog(LogDef var1);

    public Log createLog(CellAddress var1);

    public Log injectLog(Log var1);

    public PolicyDef definePolicy(Item var1);

    public Policy createPolicy(PolicyDef var1);

    public Policy createPolicy(CellAddress var1);

    public Policy injectPolicy(Policy var1);

    public ScheduleDef defineSchedule(Item var1);

    public Schedule createSchedule(ScheduleDef var1, Stage var2);

    public Schedule injectSchedule(Schedule var1);

    public StageDef defineStage(Item var1);

    public Stage createStage(StageDef var1);

    public Stage createStage(CellAddress var1);

    public Stage injectStage(Stage var1);

    public StoreDef defineStore(Item var1);

    public StoreBinding createStore(StoreDef var1, ClassLoader var2);

    public StoreBinding createStore(CellAddress var1);

    public StoreBinding injectStore(StoreBinding var1);

    public AuthenticatorDef defineAuthenticator(Item var1);

    public Authenticator createAuthenticator(AuthenticatorDef var1, ClassLoader var2);

    public Authenticator injectAuthenticator(Authenticator var1);

    public IpSettings ipSettings();

    public IpServiceRef bindTcp(InetSocketAddress var1, IpService var2, IpSettings var3);

    public IpServiceRef bindTls(InetSocketAddress var1, IpService var2, IpSettings var3);

    public IpSocketRef connectTcp(InetSocketAddress var1, IpSocket var2, IpSettings var3);

    public IpSocketRef connectTls(InetSocketAddress var1, IpSocket var2, IpSettings var3);

    @Override
    public Service getService(String var1);

    @Override
    public ServiceDef defineService(Item var1);

    @Override
    public ServiceFactory<?> createServiceFactory(ServiceDef var1, ClassLoader var2);

    @Override
    public <S extends Service> S openService(String var1, ServiceFactory<S> var2);

    public Service injectService(Service var1);

    public WebResponse routeRequest(WebRequest var1);

    @Override
    public Space getSpace(String var1);

    @Override
    public SpaceDef defineSpace(Item var1);

    @Override
    public Space openSpace(SpaceDef var1);

    @Override
    public PlaneDef definePlane(Item var1);

    @Override
    public PlaneFactory<?> createPlaneFactory(PlaneDef var1, ClassLoader var2);

    @Override
    public <P extends Plane> PlaneFactory<P> createPlaneFactory(Class<? extends P> var1);

    public Plane injectPlane(Plane var1);

    @Override
    public AgentDef defineAgent(Item var1);

    @Override
    public AgentFactory<?> createAgentFactory(AgentDef var1, ClassLoader var2);

    public AgentFactory<?> createAgentFactory(NodeBinding var1, AgentDef var2);

    @Override
    public <A extends Agent> AgentFactory<A> createAgentFactory(Class<? extends A> var1);

    public <A extends Agent> AgentFactory<A> createAgentFactory(NodeBinding var1, Class<? extends A> var2);

    public <A extends Agent> AgentRoute<A> createAgentRoute(EdgeBinding var1, Class<? extends A> var2);

    public void openAgents(NodeBinding var1);

    public void openLanes(NodeBinding var1);

    public EdgeBinding createEdge(EdgeAddress var1);

    public EdgeBinding injectEdge(EdgeAddress var1, EdgeBinding var2);

    public void openMetaEdge(EdgeBinding var1, NodeBinding var2);

    public MeshDef defineMesh(Item var1);

    public MeshDef getMeshDef(MeshAddress var1);

    public MeshBinding createMesh(EdgeBinding var1, MeshDef var2);

    public MeshBinding createMesh(MeshAddress var1);

    public MeshBinding injectMesh(MeshAddress var1, MeshBinding var2);

    public void openMetaMesh(MeshBinding var1, NodeBinding var2);

    public PartDef definePart(Item var1);

    public PartDef getPartDef(PartAddress var1);

    public PartBinding createPart(MeshBinding var1, PartDef var2);

    public PartBinding createPart(PartAddress var1);

    public PartBinding injectPart(PartAddress var1, PartBinding var2);

    public void openMetaPart(PartBinding var1, NodeBinding var2);

    public HostDef defineHost(Item var1);

    public HostDef getHostDef(HostAddress var1);

    public HostBinding createHost(PartBinding var1, HostDef var2);

    public HostBinding createHost(HostAddress var1);

    public HostBinding injectHost(HostAddress var1, HostBinding var2);

    public void openMetaHost(HostBinding var1, NodeBinding var2);

    public NodeDef defineNode(Item var1);

    public NodeDef getNodeDef(NodeAddress var1);

    public NodeBinding createNode(HostBinding var1, NodeDef var2);

    public NodeBinding createNode(NodeAddress var1);

    public NodeBinding injectNode(NodeAddress var1, NodeBinding var2);

    public void openMetaNode(NodeBinding var1, NodeBinding var2);

    public LaneDef defineLane(Item var1);

    public LaneDef getLaneDef(LaneAddress var1);

    public LaneBinding createLane(NodeBinding var1, LaneDef var2);

    public LaneBinding createLane(LaneAddress var1);

    public LaneBinding injectLane(LaneAddress var1, LaneBinding var2);

    public void openMetaLane(LaneBinding var1, NodeBinding var2);

    public void openMetaUplink(LinkBinding var1, NodeBinding var2);

    public void openMetaDownlink(LinkBinding var1, NodeBinding var2);

    public void reportDown(Metric var1);
}

