/*
 * Decompiled with CFR 0.152.
 */
package swim.linker;

import swim.api.auth.Authenticated;
import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.policy.PolicyDirective;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.ParserException;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieSet;
import swim.concurrent.TimerFunction;
import swim.concurrent.TimerRef;
import swim.io.TlsSettings;
import swim.io.http.HttpClient;
import swim.io.http.HttpSettings;
import swim.linker.AuthDef;
import swim.linker.AuthenticatorContext;
import swim.linker.GoogleIdAuthForm;
import swim.linker.GoogleIdPublicKeyClient;
import swim.linker.GoogleIdPublicKeyTimer;
import swim.security.GoogleIdToken;
import swim.security.PublicKeyDef;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.util.Murmur3;

public final class GoogleIdAuthDef
extends AuthDef
implements Debug {
    final FingerTrieSeq<String> audiences;
    HashTrieSet<String> emails;
    final Uri publicKeyUri;
    HttpSettings httpSettings;
    TimerRef publicKeyRefreshTimer;
    FingerTrieSeq<PublicKeyDef> publicKeyDefs;
    static final Uri PUBLIC_KEY_URI;
    static final long PUBLIC_KEY_REFRESH_INTERVAL;
    private static int hashSeed;
    private static Form<GoogleIdAuthDef> form;

    public GoogleIdAuthDef(FingerTrieSeq<String> audiences, HashTrieSet<String> emails) {
        this(audiences, emails, PUBLIC_KEY_URI);
    }

    public GoogleIdAuthDef(FingerTrieSeq<String> audiences, HashTrieSet<String> emails, Uri publicKeyUri) {
        this.audiences = audiences;
        this.emails = emails;
        this.publicKeyUri = publicKeyUri;
    }

    @Override
    public void setContext(AuthenticatorContext context) {
        super.setContext(context);
        this.refreshPublicKeys();
        if (this.publicKeyRefreshTimer != null) {
            this.publicKeyRefreshTimer.cancel();
        }
        this.publicKeyRefreshTimer = context.schedule().setTimer(PUBLIC_KEY_REFRESH_INTERVAL, (TimerFunction)new GoogleIdPublicKeyTimer(this));
    }

    public FingerTrieSeq<String> audiences() {
        return this.audiences;
    }

    public HashTrieSet<String> emails() {
        return this.emails;
    }

    public void addEmail(String email) {
        this.emails = this.emails.added((Object)email);
    }

    public void removeEmail(String email) {
        this.emails = this.emails.removed((Object)email);
    }

    public FingerTrieSeq<PublicKeyDef> getPublicKeyDefs() {
        return this.publicKeyDefs;
    }

    public void setPublicKeyDefs(FingerTrieSeq<PublicKeyDef> publicKeyDefs) {
        this.publicKeyDefs = publicKeyDefs;
    }

    public void refreshPublicKeys() {
        if (this.httpSettings == null) {
            this.httpSettings = HttpSettings.standard().tlsSettings(TlsSettings.standard());
        }
        UriAuthority authority = this.publicKeyUri.authority();
        String address = authority.host().address();
        int port = authority.port().number();
        if (port == 0) {
            port = 443;
        }
        this.context.endpoint().connectHttps(address, port, (HttpClient)new GoogleIdPublicKeyClient(this), this.httpSettings);
    }

    @Override
    public PolicyDirective<Identity> authenticate(Credentials credentials) {
        GoogleIdToken idToken;
        String compactJws = credentials.claims().get("idToken").stringValue(null);
        if (compactJws == null) {
            compactJws = credentials.claims().get("googleIdToken").stringValue(null);
        }
        if (compactJws != null && (idToken = GoogleIdToken.verify((String)compactJws, this.publicKeyDefs)) != null && (this.emails.isEmpty() || this.emails.contains((Object)idToken.email()))) {
            return PolicyDirective.allow((Object)new Authenticated(credentials.requestUri(), credentials.fromUri(), idToken.toValue()));
        }
        return null;
    }

    @Override
    public Value toValue() {
        return GoogleIdAuthDef.form().mold((Object)this).toValue();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof GoogleIdAuthDef) {
            GoogleIdAuthDef that = (GoogleIdAuthDef)other;
            return this.audiences.equals(that.audiences) && this.emails.equals(that.emails) && this.publicKeyUri.equals((Object)that.publicKeyUri);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(GoogleIdAuthDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.audiences.hashCode()), (int)this.emails.hashCode()), (int)this.publicKeyUri.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("new").write(32).write("GoogleIdAuthDef").write(40).debug(this.audiences).write(", ").debug(this.emails);
        if (!PUBLIC_KEY_URI.equals((Object)this.publicKeyUri)) {
            output = output.write(", ").debug((Object)this.publicKeyUri);
        }
        output = output.write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    @Kind
    public static Form<GoogleIdAuthDef> form() {
        if (form == null) {
            form = new GoogleIdAuthForm();
        }
        return form;
    }

    static {
        long publicKeyRefreshInterval;
        Uri publicKeyUri;
        try {
            publicKeyUri = Uri.parse((String)System.getProperty("swim.auth.google.public.key.uri"));
        }
        catch (NullPointerException | ParserException e) {
            publicKeyUri = Uri.parse((String)"https://www.googleapis.com/oauth2/v3/certs");
        }
        PUBLIC_KEY_URI = publicKeyUri;
        try {
            publicKeyRefreshInterval = Long.parseLong(System.getProperty("swim.auth.google.public.key.refresh.interval"));
        }
        catch (NumberFormatException e) {
            publicKeyRefreshInterval = 3600000L;
        }
        PUBLIC_KEY_REFRESH_INTERVAL = publicKeyRefreshInterval;
    }
}

