/*
 * Decompiled with CFR 0.152.
 */
package swim.linker;

import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.http.header.Host;
import swim.io.http.AbstractHttpRequester;
import swim.linker.GoogleIdAuthDef;
import swim.security.JsonWebKey;
import swim.security.PublicKeyDef;
import swim.structure.Item;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriPath;

final class GoogleIdPublicKeyRequester
extends AbstractHttpRequester<Value> {
    final GoogleIdAuthDef authDef;

    GoogleIdPublicKeyRequester(GoogleIdAuthDef authDef) {
        this.authDef = authDef;
    }

    public void doRequest() {
        Uri publicKeyUri = this.authDef.publicKeyUri;
        Uri requestUri = Uri.from((UriPath)publicKeyUri.path());
        HttpRequest request = HttpRequest.get((Uri)requestUri, (HttpHeader[])new HttpHeader[]{Host.from((UriAuthority)publicKeyUri.authority())});
        this.writeRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void didRespond(HttpResponse<Value> response) {
        FingerTrieSeq publicKeyDefs = FingerTrieSeq.empty();
        try {
            for (Item item : ((Value)response.entity().get()).get("keys")) {
                PublicKeyDef publicKeyDef = JsonWebKey.from((Value)item.toValue()).publicKeyDef();
                if (publicKeyDef == null) continue;
                publicKeyDefs = publicKeyDefs.appended((Object)publicKeyDef);
            }
            this.authDef.setPublicKeyDefs((FingerTrieSeq<PublicKeyDef>)publicKeyDefs);
        }
        finally {
            this.close();
        }
    }
}

