/*
 * Decompiled with CFR 0.152.
 */
package swim.linker;

import swim.io.warp.WarpSettings;
import swim.linker.HttpServiceDef;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;

final class HttpServiceForm
extends Form<HttpServiceDef> {
    HttpServiceForm() {
    }

    public String tag() {
        return "http";
    }

    public Class<?> type() {
        return HttpServiceDef.class;
    }

    public Item mold(HttpServiceDef serviceDef) {
        if (serviceDef != null) {
            Value headers = Value.absent();
            if (!"0.0.0.0".equals(serviceDef.address)) {
                headers = headers.updated("address", serviceDef.address);
            }
            if (serviceDef.port != 80) {
                headers = headers.updated("port", serviceDef.port);
            }
            if (!headers.isDefined()) {
                headers = Value.extant();
            }
            Record record = Record.create().attr(this.tag(), headers);
            if (serviceDef.planeName != null) {
                record.slot("plane", serviceDef.planeName);
            }
            if (serviceDef.documentRoot != null) {
                record.slot("documentRoot", serviceDef.documentRoot.toString());
            }
            return record.concat((Item)serviceDef.warpSettings.toValue());
        }
        return Item.extant();
    }

    public HttpServiceDef cast(Item item) {
        Value value = item.toValue();
        Value headers = value.getAttr(this.tag());
        if (headers.isDefined()) {
            String address = headers.get("address").stringValue("0.0.0.0");
            int port = headers.get("port").intValue(80);
            String planeName = value.get("plane").stringValue(null);
            WarpSettings warpSettings = (WarpSettings)WarpSettings.form().cast((Item)value);
            if (warpSettings.tlsSettings() != null) {
                warpSettings = warpSettings.tlsSettings(null);
            }
            Uri documentRoot = (Uri)value.get("documentRoot").cast(Uri.form());
            return new HttpServiceDef(address, port, planeName, documentRoot, warpSettings);
        }
        return null;
    }
}

