/*
 * Decompiled with CFR 0.152.
 */
package swim.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.ServiceLoader;
import swim.api.SwimContext;
import swim.api.plane.Plane;
import swim.api.plane.PlaneException;
import swim.api.router.Router;
import swim.api.server.Server;
import swim.api.server.ServerContext;
import swim.api.storage.Storage;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.linker.ServerDef;
import swim.linker.ServerLinker;
import swim.linker.StorageLinker;
import swim.loader.GenericServer;
import swim.loader.RouterLoader;
import swim.loader.StorageLoader;
import swim.recon.Recon;
import swim.structure.Item;
import swim.structure.Value;

public final class ServerLoader {
    private ServerLoader() {
    }

    public static void main(String[] args) throws IOException {
        ServerContext server = ServerLoader.loadServerContext();
        if (server instanceof ServerLinker) {
            ServiceLoader<Plane> planeLoader = ServiceLoader.load(Plane.class);
            planeLoader.stream().forEach(planeProvider -> {
                try {
                    ServerDef serverDef = ServerLoader.loadServerDef(planeProvider.type().getModule());
                    ((ServerLinker)server).materialize(serverDef);
                }
                catch (IOException error) {
                    throw new PlaneException((Throwable)error);
                }
            });
        }
        server.start();
        server.run();
    }

    public static Server load(Module module) throws IOException {
        ServerContext context = ServerLoader.loadServerContext();
        Router router = RouterLoader.loadRouter();
        context.setRouter(router);
        Storage storage = StorageLoader.loadStorage();
        context.setStorage(storage);
        Server server = ServerLoader.loadServer(context);
        if (context instanceof ServerLinker) {
            ServerDef serverDef = ServerLoader.loadServerDef(module);
            if (storage instanceof StorageLinker) {
                ((StorageLinker)storage).materialize(serverDef.storeDef());
            }
            ((ServerLinker)context).materialize(serverDef);
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Server loadServer(ServerContext context) {
        try {
            SwimContext.setServerContext((ServerContext)context);
            ServiceLoader<Server> serverLoader = ServiceLoader.load(Server.class);
            Iterator<Server> servers = serverLoader.iterator();
            if (servers.hasNext()) {
                Server server = servers.next();
                return server;
            }
            GenericServer genericServer = new GenericServer();
            return genericServer;
        }
        finally {
            SwimContext.setServerContext(null);
        }
    }

    public static ServerContext loadServerContext() {
        ServiceLoader<ServerContext> serverContextLoader = ServiceLoader.load(ServerContext.class);
        Iterator<ServerContext> serverContexts = serverContextLoader.iterator();
        if (serverContexts.hasNext()) {
            return serverContexts.next();
        }
        return null;
    }

    private static ServerDef loadServerDef(Module module) throws IOException {
        Value configValue = ServerLoader.loadConfigValue(module);
        return (ServerDef)ServerDef.form().cast((Item)configValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Value loadConfigValue(Module module) throws IOException {
        Value configValue;
        String configPath = System.getProperty("swim.config");
        if (configPath == null) {
            configPath = "/server.recon";
        }
        InputStream configInput = null;
        try {
            File configFile = new File(configPath);
            configInput = configFile.exists() ? new FileInputStream(configFile) : module.getResourceAsStream(configPath);
            configValue = configInput != null ? (Value)Utf8.read((Parser)Recon.structureParser().blockParser(), (InputStream)configInput) : Value.absent();
        }
        finally {
            try {
                if (configInput != null) {
                    configInput.close();
                }
            }
            catch (IOException iOException) {}
        }
        return configValue;
    }
}

