/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.mqtt.MqttConnAck;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttException;

final class MqttConnAckDecoder
extends Decoder<MqttConnAck> {
    final MqttDecoder mqtt;
    final int packetFlags;
    final int connectFlags;
    final int connectCode;
    final int remaining;
    final int step;

    MqttConnAckDecoder(MqttDecoder mqtt, int packetFlags, int connectFlags, int connectCode, int remaining, int step) {
        this.mqtt = mqtt;
        this.packetFlags = packetFlags;
        this.connectFlags = connectFlags;
        this.connectCode = connectCode;
        this.remaining = remaining;
        this.step = step;
    }

    MqttConnAckDecoder(MqttDecoder mqtt) {
        this(mqtt, 0, 0, 0, 0, 1);
    }

    static Decoder<MqttConnAck> decode(InputBuffer input, MqttDecoder mqtt, int packetFlags, int connectFlags, int connectCode, int remaining, int step) {
        if (step == 1 && input.isCont()) {
            packetFlags = input.head() & 0xF;
            input = input.step();
            step = 2;
        }
        while (step >= 2 && step <= 5 && input.isCont()) {
            int b = input.head();
            input = input.step();
            remaining |= (b & 0x7F) << 7 * (step - 2);
            if ((b & 0x80) == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return MqttConnAckDecoder.error((Throwable)new MqttException("packet length too long"));
        }
        if (step == 6 && remaining > 0 && input.isCont()) {
            connectFlags = input.head();
            input = input.step();
            --remaining;
            step = 7;
        }
        if (step == 7 && remaining > 0 && input.isCont()) {
            connectCode = input.head();
            input = input.step();
            --remaining;
            step = 8;
        }
        if (step == 8 && remaining == 0) {
            return MqttConnAckDecoder.done((Object)mqtt.connAck(packetFlags, connectFlags, connectCode));
        }
        if (remaining < 0) {
            return MqttConnAckDecoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (input.isDone()) {
            return MqttConnAckDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        return new MqttConnAckDecoder(mqtt, packetFlags, connectFlags, connectCode, remaining, step);
    }

    static Decoder<MqttConnAck> decode(InputBuffer input, MqttDecoder mqtt) {
        return MqttConnAckDecoder.decode(input, mqtt, 0, 0, 0, 0, 1);
    }

    public Decoder<MqttConnAck> feed(InputBuffer input) {
        return MqttConnAckDecoder.decode(input, this.mqtt, this.packetFlags, this.connectFlags, this.connectCode, this.remaining, this.step);
    }
}

