/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttConnect;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttException;

final class MqttConnectEncoder
extends Encoder<Object, MqttConnect> {
    final MqttEncoder mqtt;
    final MqttConnect packet;
    final Encoder<?, ?> part;
    final int length;
    final int remaining;
    final int step;

    MqttConnectEncoder(MqttEncoder mqtt, MqttConnect packet, Encoder<?, ?> part, int length, int remaining, int step) {
        this.mqtt = mqtt;
        this.packet = packet;
        this.part = part;
        this.length = length;
        this.remaining = remaining;
        this.step = step;
    }

    MqttConnectEncoder(MqttEncoder mqtt, MqttConnect packet) {
        this(mqtt, packet, null, 0, 0, 1);
    }

    static Encoder<Object, MqttConnect> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttConnect packet, Encoder<?, ?> part, int length, int remaining, int step) {
        boolean outputPart;
        int outputRemaining;
        int outputLimit;
        int outputStart;
        if (step == 1 && output.isCont()) {
            remaining = length = packet.bodySize(mqtt);
            output = output.write(packet.packetType() << 4 | packet.packetFlags & 0xF);
            step = 2;
        }
        while (step >= 2 && step <= 5 && output.isCont()) {
            int b = length & 0x7F;
            if ((length >>>= 7) > 0) {
                b |= 0x80;
            }
            output = output.write(b);
            if (length == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return MqttConnectEncoder.error((Throwable)new MqttException("packet length too long: " + remaining));
        }
        if (step == 6) {
            outputStart = output.index();
            outputLimit = output.limit();
            outputRemaining = outputLimit - outputStart;
            if (remaining < outputRemaining) {
                output = output.limit(outputStart + remaining);
            }
            outputPart = output.isPart();
            output = output.isPart(remaining > outputRemaining);
            part = part == null ? mqtt.encodeString(packet.protocolName, output) : part.pull(output);
            output = output.limit(outputLimit).isPart(outputPart);
            remaining -= output.index() - outputStart;
            if (part.isDone()) {
                part = null;
                step = 7;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 7 && remaining > 0 && output.isCont()) {
            output = output.write(packet.protocolLevel);
            --remaining;
            step = 8;
        }
        if (step == 8 && remaining > 0 && output.isCont()) {
            output = output.write(packet.connectFlags);
            --remaining;
            step = 9;
        }
        if (step == 9 && remaining > 0 && output.isCont()) {
            output = output.write(packet.keepAlive >>> 8);
            --remaining;
            step = 10;
        }
        if (step == 10 && remaining > 0 && output.isCont()) {
            output = output.write(packet.keepAlive);
            --remaining;
            step = 11;
        }
        if (step == 11) {
            outputStart = output.index();
            outputLimit = output.limit();
            outputRemaining = outputLimit - outputStart;
            if (remaining < outputRemaining) {
                output = output.limit(outputStart + remaining);
            }
            outputPart = output.isPart();
            output = output.isPart(remaining > outputRemaining);
            part = part == null ? mqtt.encodeString(packet.clientId, output) : part.pull(output);
            output = output.limit(outputLimit).isPart(outputPart);
            remaining -= output.index() - outputStart;
            if (part.isDone()) {
                part = null;
                step = (packet.connectFlags & 4) != 0 ? 12 : ((packet.connectFlags & 0x80) != 0 ? 14 : ((packet.connectFlags & 0x40) != 0 ? 15 : 16));
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 12) {
            outputStart = output.index();
            outputLimit = output.limit();
            outputRemaining = outputLimit - outputStart;
            if (remaining < outputRemaining) {
                output = output.limit(outputStart + remaining);
            }
            outputPart = output.isPart();
            output = output.isPart(remaining > outputRemaining);
            part = part == null ? mqtt.encodeString(packet.willTopic, output) : part.pull(output);
            output = output.limit(outputLimit).isPart(outputPart);
            remaining -= output.index() - outputStart;
            if (part.isDone()) {
                part = null;
                step = 13;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 13) {
            outputStart = output.index();
            outputLimit = output.limit();
            outputRemaining = outputLimit - outputStart;
            if (remaining < outputRemaining) {
                output = output.limit(outputStart + remaining);
            }
            outputPart = output.isPart();
            output = output.isPart(remaining > outputRemaining);
            part = part == null ? mqtt.encodeData(packet.willMessage, output) : part.pull(output);
            output = output.limit(outputLimit).isPart(outputPart);
            remaining -= output.index() - outputStart;
            if (part.isDone()) {
                part = null;
                step = (packet.connectFlags & 0x80) != 0 ? 14 : ((packet.connectFlags & 0x40) != 0 ? 15 : 16);
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 14) {
            outputStart = output.index();
            outputLimit = output.limit();
            outputRemaining = outputLimit - outputStart;
            if (remaining < outputRemaining) {
                output = output.limit(outputStart + remaining);
            }
            outputPart = output.isPart();
            output = output.isPart(remaining > outputRemaining);
            part = part == null ? mqtt.encodeString(packet.username, output) : part.pull(output);
            output = output.limit(outputLimit).isPart(outputPart);
            remaining -= output.index() - outputStart;
            if (part.isDone()) {
                part = null;
                step = (packet.connectFlags & 0x40) != 0 ? 15 : 16;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 15) {
            outputStart = output.index();
            outputLimit = output.limit();
            outputRemaining = outputLimit - outputStart;
            if (remaining < outputRemaining) {
                output = output.limit(outputStart + remaining);
            }
            outputPart = output.isPart();
            output = output.isPart(remaining > outputRemaining);
            part = part == null ? mqtt.encodeData(packet.password, output) : part.pull(output);
            output = output.limit(outputLimit).isPart(outputPart);
            remaining -= output.index() - outputStart;
            if (part.isDone()) {
                part = null;
                step = 16;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 16 && remaining == 0) {
            return MqttConnectEncoder.done((Object)packet);
        }
        if (remaining < 0) {
            return MqttConnectEncoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (output.isDone()) {
            return MqttConnectEncoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return MqttConnectEncoder.error((Throwable)output.trap());
        }
        return new MqttConnectEncoder(mqtt, packet, part, length, remaining, step);
    }

    static Encoder<Object, MqttConnect> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttConnect packet) {
        return MqttConnectEncoder.encode(output, mqtt, packet, null, 0, 0, 1);
    }

    public Encoder<Object, MqttConnect> pull(OutputBuffer<?> output) {
        return MqttConnectEncoder.encode(output, this.mqtt, this.packet, this.part, this.length, this.remaining, this.step);
    }
}

