/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttDisconnect;
import swim.mqtt.MqttException;

final class MqttDisconnectDecoder
extends Decoder<MqttDisconnect> {
    final MqttDecoder mqtt;
    final int packetFlags;
    final int remaining;
    final int step;

    MqttDisconnectDecoder(MqttDecoder mqtt, int packetFlags, int remaining, int step) {
        this.mqtt = mqtt;
        this.packetFlags = packetFlags;
        this.remaining = remaining;
        this.step = step;
    }

    MqttDisconnectDecoder(MqttDecoder mqtt) {
        this(mqtt, 0, 0, 1);
    }

    static Decoder<MqttDisconnect> decode(InputBuffer input, MqttDecoder mqtt, int packetFlags, int remaining, int step) {
        if (step == 1 && input.isCont()) {
            packetFlags = input.head() & 0xF;
            input = input.step();
            step = 2;
        }
        while (step >= 2 && step <= 5 && input.isCont()) {
            int b = input.head();
            input = input.step();
            remaining |= (b & 0x7F) << 7 * (step - 2);
            if ((b & 0x80) == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return MqttDisconnectDecoder.error((Throwable)new MqttException("packet length too long"));
        }
        if (step == 6 && remaining == 0) {
            return MqttDisconnectDecoder.done((Object)mqtt.disconnect(packetFlags));
        }
        if (remaining < 0) {
            return MqttDisconnectDecoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (input.isDone()) {
            return MqttDisconnectDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return MqttDisconnectDecoder.error((Throwable)input.trap());
        }
        return new MqttDisconnectDecoder(mqtt, packetFlags, remaining, step);
    }

    static Decoder<MqttDisconnect> decode(InputBuffer input, MqttDecoder mqtt) {
        return MqttDisconnectDecoder.decode(input, mqtt, 0, 0, 1);
    }

    public Decoder<MqttDisconnect> feed(InputBuffer input) {
        return MqttDisconnectDecoder.decode(input, this.mqtt, this.packetFlags, this.remaining, this.step);
    }
}

