/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import java.nio.ByteBuffer;
import swim.codec.Binary;
import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.codec.Utf8;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttEntity;
import swim.util.Murmur3;

public final class MqttPayload<T>
extends MqttEntity<T>
implements Debug {
    private static int hashSeed;
    private static MqttPayload<Object> empty;
    final T value;
    final Encoder<?, ?> content;
    final int length;

    MqttPayload(T value, Encoder<?, ?> content, int length) {
        this.value = value;
        this.content = content;
        this.length = length;
    }

    public static <T> MqttPayload<T> empty() {
        if (empty == null) {
            empty = new MqttPayload<Object>(null, Encoder.done(), 0);
        }
        return empty;
    }

    public static <T> MqttPayload<T> from(T value, Encoder<?, ?> content, int length) {
        return new MqttPayload<T>(value, content, length);
    }

    public static <T> MqttPayload<T> from(Encoder<?, ?> content, int length) {
        return new MqttPayload<Object>(null, content, length);
    }

    public static <T> MqttPayload<T> from(ByteBuffer data) {
        return new MqttPayload<Object>(null, (Encoder<?, ?>)Binary.byteBufferWriter((ByteBuffer)data), data.remaining());
    }

    public static MqttPayload<String> from(String content) {
        Output output = Utf8.encodedOutput((Output)Binary.byteBufferOutput((int)content.length()));
        output = output.write(content);
        ByteBuffer data = (ByteBuffer)output.bind();
        return new MqttPayload<String>(content, (Encoder<?, ?>)Binary.byteBufferWriter((ByteBuffer)data), data.remaining());
    }

    @Override
    public boolean isDefined() {
        return this.value != null;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public int mqttSize() {
        return this.length;
    }

    @Override
    public Encoder<?, ?> mqttEncoder(MqttEncoder mqtt) {
        return this.content;
    }

    @Override
    public Encoder<?, ?> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return this.content.pull(output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttPayload) {
            MqttPayload that = (MqttPayload)other;
            return (this.value == null ? that.value == null : this.value.equals(that.value)) && this.content.equals(that.content) && this.length == that.length;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttPayload.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash(this.value)), (int)this.content.hashCode()), (int)this.length));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttPayload").write(46);
        if (this.value == null && this.content.isDone() && this.length == 0) {
            output = output.write("empty").write(40).write(41);
        } else {
            output = output.write("from").write(40);
            if (this.value != null) {
                output.debug(this.value).write(", ");
            }
            output.debug(this.content).write(", ").debug((Object)this.length).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

