/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.util.Murmur3;

public final class MqttPingResp
extends MqttPacket<Object>
implements Debug {
    private static int hashSeed;
    private static MqttPingResp packet;
    final int packetFlags;

    MqttPingResp(int packetFlags) {
        this.packetFlags = packetFlags;
    }

    public static MqttPingResp packet() {
        if (packet == null) {
            packet = new MqttPingResp(0);
        }
        return packet;
    }

    public static MqttPingResp from(int packetFlags) {
        if (packetFlags == 0) {
            return MqttPingResp.packet();
        }
        return new MqttPingResp(packetFlags);
    }

    @Override
    public int packetType() {
        return 13;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttPingResp packetFlags(int packetFlags) {
        return new MqttPingResp(packetFlags);
    }

    @Override
    int bodySize(MqttEncoder mqtt) {
        return 0;
    }

    public Encoder<?, MqttPingResp> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.pingRespEncoder(this);
    }

    public Encoder<?, MqttPingResp> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodePingResp(this, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttPingResp) {
            MqttPingResp that = (MqttPingResp)other;
            return this.packetFlags == that.packetFlags;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttPingResp.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttPingResp").write(46).write("packet").write(40).write(41);
        if (this.packetFlags != 0) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

