/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttPingResp;

final class MqttPingRespDecoder
extends Decoder<MqttPingResp> {
    final MqttDecoder mqtt;
    final int packetFlags;
    final int remaining;
    final int step;

    MqttPingRespDecoder(MqttDecoder mqtt, int packetFlags, int remaining, int step) {
        this.mqtt = mqtt;
        this.packetFlags = packetFlags;
        this.remaining = remaining;
        this.step = step;
    }

    MqttPingRespDecoder(MqttDecoder mqtt) {
        this(mqtt, 0, 0, 1);
    }

    static Decoder<MqttPingResp> decode(InputBuffer input, MqttDecoder mqtt, int packetFlags, int remaining, int step) {
        if (step == 1 && input.isCont()) {
            packetFlags = input.head() & 0xF;
            input = input.step();
            step = 2;
        }
        while (step >= 2 && step <= 5 && input.isCont()) {
            int b = input.head();
            input = input.step();
            remaining |= (b & 0x7F) << 7 * (step - 2);
            if ((b & 0x80) == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return MqttPingRespDecoder.error((Throwable)new MqttException("packet length too long"));
        }
        if (step == 6 && remaining == 0) {
            return MqttPingRespDecoder.done((Object)mqtt.pingResp(packetFlags));
        }
        if (remaining < 0) {
            return MqttPingRespDecoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (input.isDone()) {
            return MqttPingRespDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return MqttPingRespDecoder.error((Throwable)input.trap());
        }
        return new MqttPingRespDecoder(mqtt, packetFlags, remaining, step);
    }

    static Decoder<MqttPingResp> decode(InputBuffer input, MqttDecoder mqtt) {
        return MqttPingRespDecoder.decode(input, mqtt, 0, 0, 1);
    }

    public Decoder<MqttPingResp> feed(InputBuffer input) {
        return MqttPingRespDecoder.decode(input, this.mqtt, this.packetFlags, this.remaining, this.step);
    }
}

