/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttPingResp;

final class MqttPingRespEncoder
extends Encoder<Object, MqttPingResp> {
    final MqttEncoder mqtt;
    final MqttPingResp packet;
    final int length;
    final int remaining;
    final int step;

    MqttPingRespEncoder(MqttEncoder mqtt, MqttPingResp packet, int length, int remaining, int step) {
        this.mqtt = mqtt;
        this.packet = packet;
        this.length = length;
        this.remaining = remaining;
        this.step = step;
    }

    MqttPingRespEncoder(MqttEncoder mqtt, MqttPingResp packet) {
        this(mqtt, packet, 0, 0, 1);
    }

    static Encoder<Object, MqttPingResp> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttPingResp packet, int length, int remaining, int step) {
        if (step == 1 && output.isCont()) {
            remaining = length = packet.bodySize(mqtt);
            output = output.write(packet.packetType() << 4 | packet.packetFlags & 0xF);
            step = 2;
        }
        while (step >= 2 && step <= 5 && output.isCont()) {
            int b = length & 0x7F;
            if ((length >>>= 7) > 0) {
                b |= 0x80;
            }
            output = output.write(b);
            if (length == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return MqttPingRespEncoder.error((Throwable)new MqttException("packet length too long: " + remaining));
        }
        if (step == 6 && remaining == 0) {
            return MqttPingRespEncoder.done((Object)packet);
        }
        if (remaining < 0) {
            return MqttPingRespEncoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (output.isDone()) {
            return MqttPingRespEncoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return MqttPingRespEncoder.error((Throwable)output.trap());
        }
        return new MqttPingRespEncoder(mqtt, packet, length, remaining, step);
    }

    static Encoder<Object, MqttPingResp> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttPingResp packet) {
        return MqttPingRespEncoder.encode(output, mqtt, packet, 0, 0, 1);
    }

    public Encoder<Object, MqttPingResp> pull(OutputBuffer<?> output) {
        return MqttPingRespEncoder.encode(output, this.mqtt, this.packet, this.length, this.remaining, this.step);
    }
}

