/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.util.Murmur3;

public final class MqttPubRec
extends MqttPacket<Object>
implements Debug {
    private static int hashSeed;
    final int packetFlags;
    final int packetId;

    MqttPubRec(int packetFlags, int packetId) {
        this.packetFlags = packetFlags;
        this.packetId = packetId;
    }

    public static MqttPubRec from(int packetFlags, int packetId) {
        return new MqttPubRec(packetFlags, packetId);
    }

    public static MqttPubRec from(int packetId) {
        return new MqttPubRec(0, packetId);
    }

    @Override
    public int packetType() {
        return 5;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttPubRec packetFlags(int packetFlags) {
        return new MqttPubRec(packetFlags, this.packetId);
    }

    public int packetId() {
        return this.packetId;
    }

    public MqttPubRec packetId(int packetId) {
        return new MqttPubRec(this.packetFlags, packetId);
    }

    @Override
    int bodySize(MqttEncoder mqtt) {
        return 2;
    }

    public Encoder<?, MqttPubRec> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.pubRecEncoder(this);
    }

    public Encoder<?, MqttPubRec> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodePubRec(this, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttPubRec) {
            MqttPubRec that = (MqttPubRec)other;
            return this.packetFlags == that.packetFlags && this.packetId == that.packetId;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttPubRec.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.packetId));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttPubRec").write(46).write("from").write(40).debug((Object)this.packetId).write(41);
        if (this.packetFlags != 0) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

