/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttPublish;

final class MqttPublishEncoder<T>
extends Encoder<Object, MqttPublish<T>> {
    final MqttEncoder mqtt;
    final MqttPublish<T> packet;
    final Encoder<?, ?> part;
    final int length;
    final int remaining;
    final int step;

    MqttPublishEncoder(MqttEncoder mqtt, MqttPublish<T> packet, Encoder<?, ?> part, int length, int remaining, int step) {
        this.mqtt = mqtt;
        this.packet = packet;
        this.part = part;
        this.length = length;
        this.remaining = remaining;
        this.step = step;
    }

    MqttPublishEncoder(MqttEncoder mqtt, MqttPublish<T> packet) {
        this(mqtt, packet, null, 0, 0, 1);
    }

    static <T> Encoder<Object, MqttPublish<T>> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttPublish<T> packet, Encoder<?, ?> part, int length, int remaining, int step) {
        boolean outputPart;
        int outputRemaining;
        int outputLimit;
        int outputStart;
        if (step == 1 && output.isCont()) {
            remaining = length = packet.bodySize(mqtt);
            output = output.write(packet.packetType() << 4 | packet.packetFlags & 0xF);
            step = 2;
        }
        while (step >= 2 && step <= 5 && output.isCont()) {
            int b = length & 0x7F;
            if ((length >>>= 7) > 0) {
                b |= 0x80;
            }
            output = output.write(b);
            if (length == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return MqttPublishEncoder.error((Throwable)new MqttException("packet length too long: " + remaining));
        }
        if (step == 6) {
            outputStart = output.index();
            outputLimit = output.limit();
            outputRemaining = outputLimit - outputStart;
            if (remaining < outputRemaining) {
                output = output.limit(outputStart + remaining);
            }
            outputPart = output.isPart();
            output = output.isPart(remaining > outputRemaining);
            part = part == null ? mqtt.encodeString(packet.topicName, output) : part.pull(output);
            output = output.limit(outputLimit).isPart(outputPart);
            remaining -= output.index() - outputStart;
            if (part.isDone()) {
                part = null;
                step = packet.hasPacketId() ? 7 : 9;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 7 && remaining > 0 && output.isCont()) {
            output = output.write(packet.packetId >>> 8);
            --remaining;
            step = 8;
        }
        if (step == 8 && remaining > 0 && output.isCont()) {
            output = output.write(packet.packetId);
            --remaining;
            step = 9;
        }
        if (step == 9) {
            outputStart = output.index();
            outputLimit = output.limit();
            outputRemaining = outputLimit - outputStart;
            if (remaining < outputRemaining) {
                output = output.limit(outputStart + remaining);
            }
            outputPart = output.isPart();
            output = output.isPart(remaining > outputRemaining);
            part = part == null ? packet.payload.encodeMqtt(output) : part.pull(output);
            output = output.limit(outputLimit).isPart(outputPart);
            remaining -= output.index() - outputStart;
            if (part.isDone()) {
                part = null;
                step = 10;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 10 && remaining == 0) {
            return MqttPublishEncoder.done(packet);
        }
        if (remaining < 0) {
            return MqttPublishEncoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (output.isDone()) {
            return MqttPublishEncoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return MqttPublishEncoder.error((Throwable)output.trap());
        }
        return new MqttPublishEncoder<T>(mqtt, packet, part, length, remaining, step);
    }

    static <T> Encoder<Object, MqttPublish<T>> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttPublish<T> packet) {
        return MqttPublishEncoder.encode(output, mqtt, packet, null, 0, 0, 1);
    }

    public Encoder<Object, MqttPublish<T>> pull(OutputBuffer<?> output) {
        return MqttPublishEncoder.encode(output, this.mqtt, this.packet, this.part, this.length, this.remaining, this.step);
    }
}

