/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.Input;
import swim.codec.InputBuffer;
import swim.codec.Utf8;

final class MqttStringDecoder
extends Decoder<String> {
    final Decoder<String> decoder;
    final int remaining;
    final int step;

    MqttStringDecoder(Decoder<String> decoder, int remaining, int step) {
        this.decoder = decoder;
        this.remaining = remaining;
        this.step = step;
    }

    MqttStringDecoder() {
        this(null, 0, 1);
    }

    static Decoder<String> decode(InputBuffer input, Decoder<String> decoder, int remaining, int step) {
        if (step == 1 && input.isCont()) {
            remaining = input.head() << 8;
            input = input.step();
            step = 2;
        }
        if (step == 2 && input.isCont()) {
            remaining |= input.head();
            input = input.step();
            step = 3;
        }
        if (step == 3) {
            int inputStart = input.index();
            int inputLimit = input.limit();
            int inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            boolean inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            decoder = decoder == null ? Utf8.parseString((Input)input) : decoder.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (decoder.isDone()) {
                return MqttStringDecoder.done((Object)((String)decoder.bind()));
            }
            if (decoder.isError()) {
                return decoder.asError();
            }
        }
        if (input.isDone()) {
            return MqttStringDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return MqttStringDecoder.error((Throwable)input.trap());
        }
        return new MqttStringDecoder((Decoder<String>)decoder, remaining, step);
    }

    static Decoder<String> decode(InputBuffer input) {
        return MqttStringDecoder.decode(input, null, 0, 1);
    }

    public Decoder<String> feed(InputBuffer input) {
        return MqttStringDecoder.decode(input, this.decoder, this.remaining, this.step);
    }
}

