/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.mqtt.MqttConnect;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttException;
import swim.structure.Data;

final class MqttConnectDecoder
extends Decoder<MqttConnect> {
    final MqttDecoder mqtt;
    final int packetFlags;
    final Decoder<String> protocolName;
    final int protocolLevel;
    final int connectFlags;
    final int keepAlive;
    final Decoder<String> clientId;
    final Decoder<String> willTopic;
    final Decoder<Data> willMessage;
    final Decoder<String> username;
    final Decoder<Data> password;
    final int remaining;
    final int step;

    MqttConnectDecoder(MqttDecoder mqtt, int packetFlags, Decoder<String> protocolName, int protocolLevel, int connectFlags, int keepAlive, Decoder<String> clientId, Decoder<String> willTopic, Decoder<Data> willMessage, Decoder<String> username, Decoder<Data> password, int remaining, int step) {
        this.mqtt = mqtt;
        this.packetFlags = packetFlags;
        this.remaining = remaining;
        this.protocolName = protocolName;
        this.protocolLevel = protocolLevel;
        this.connectFlags = connectFlags;
        this.keepAlive = keepAlive;
        this.clientId = clientId;
        this.willTopic = willTopic;
        this.willMessage = willMessage;
        this.username = username;
        this.password = password;
        this.step = step;
    }

    MqttConnectDecoder(MqttDecoder mqtt) {
        this(mqtt, 0, null, 0, 0, 0, null, null, null, null, null, 0, 1);
    }

    static Decoder<MqttConnect> decode(InputBuffer input, MqttDecoder mqtt, int packetFlags, Decoder<String> protocolName, int protocolLevel, int connectFlags, int keepAlive, Decoder<String> clientId, Decoder<String> willTopic, Decoder<Data> willMessage, Decoder<String> username, Decoder<Data> password, int remaining, int step) {
        boolean inputPart;
        int inputRemaining;
        int inputLimit;
        int inputStart;
        if (step == 1 && input.isCont()) {
            packetFlags = input.head() & 0xF;
            input = input.step();
            step = 2;
        }
        while (step >= 2 && step <= 5 && input.isCont()) {
            int b = input.head();
            input = input.step();
            remaining |= (b & 0x7F) << 7 * (step - 2);
            if ((b & 0x80) == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return MqttConnectDecoder.error((Throwable)new MqttException("packet length too long"));
        }
        if (step == 6) {
            inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            protocolName = protocolName == null ? mqtt.decodeString(input) : protocolName.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (protocolName.isDone()) {
                step = 7;
            } else if (protocolName.isError()) {
                return protocolName.asError();
            }
        }
        if (step == 7 && remaining > 0 && input.isCont()) {
            protocolLevel = input.head();
            input = input.step();
            --remaining;
            step = 8;
        }
        if (step == 8 && remaining > 0 && input.isCont()) {
            connectFlags = input.head();
            input = input.step();
            --remaining;
            step = 9;
        }
        if (step == 9 && remaining > 0 && input.isCont()) {
            keepAlive = input.head() << 8;
            input = input.step();
            --remaining;
            step = 10;
        }
        if (step == 10 && remaining > 0 && input.isCont()) {
            keepAlive |= input.head();
            input = input.step();
            --remaining;
            step = 11;
        }
        if (step == 11) {
            inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            clientId = clientId == null ? mqtt.decodeString(input) : clientId.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (clientId.isDone()) {
                step = (connectFlags & 4) != 0 ? 12 : ((connectFlags & 0x80) != 0 ? 14 : ((connectFlags & 0x40) != 0 ? 15 : 16));
            } else if (clientId.isError()) {
                return clientId.asError();
            }
        }
        if (step == 12) {
            inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            willTopic = willTopic == null ? mqtt.decodeString(input) : willTopic.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (willTopic.isDone()) {
                step = 13;
            } else if (willTopic.isError()) {
                return willTopic.asError();
            }
        }
        if (step == 13) {
            inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            willMessage = willMessage == null ? mqtt.decodeData(input) : willMessage.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (willMessage.isDone()) {
                step = (connectFlags & 0x80) != 0 ? 14 : ((connectFlags & 0x40) != 0 ? 15 : 16);
            } else if (willMessage.isError()) {
                return willMessage.asError();
            }
        }
        if (step == 14) {
            inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            username = username == null ? mqtt.decodeString(input) : username.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (username.isDone()) {
                step = (connectFlags & 0x40) != 0 ? 15 : 16;
            } else if (username.isError()) {
                return username.asError();
            }
        }
        if (step == 15) {
            inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            password = password == null ? mqtt.decodeData(input) : password.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (password.isDone()) {
                step = 16;
            } else if (password.isError()) {
                return password.asError();
            }
        }
        if (step == 16 && remaining == 0) {
            return MqttConnectDecoder.done((Object)mqtt.connect(packetFlags, (String)protocolName.bind(), protocolLevel, connectFlags, keepAlive, clientId != null ? (String)clientId.bind() : null, willTopic != null ? (String)willTopic.bind() : null, willMessage != null ? (Data)willMessage.bind() : null, username != null ? (String)username.bind() : null, password != null ? (Data)password.bind() : null));
        }
        if (remaining < 0) {
            return MqttConnectDecoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (input.isDone()) {
            return MqttConnectDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return MqttConnectDecoder.error((Throwable)input.trap());
        }
        return new MqttConnectDecoder(mqtt, packetFlags, (Decoder<String>)protocolName, protocolLevel, connectFlags, keepAlive, (Decoder<String>)clientId, (Decoder<String>)willTopic, (Decoder<Data>)willMessage, (Decoder<String>)username, (Decoder<Data>)password, remaining, step);
    }

    static Decoder<MqttConnect> decode(InputBuffer input, MqttDecoder mqtt) {
        return MqttConnectDecoder.decode(input, mqtt, 0, null, 0, 0, 0, null, null, null, null, null, 0, 1);
    }

    public Decoder<MqttConnect> feed(InputBuffer input) {
        return MqttConnectDecoder.decode(input, this.mqtt, this.packetFlags, this.protocolName, this.protocolLevel, this.connectFlags, this.keepAlive, this.clientId, this.willTopic, this.willMessage, this.username, this.password, this.remaining, this.step);
    }
}

