/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.util.Murmur3;

public final class MqttDisconnect
extends MqttPacket<Object>
implements Debug {
    private static int hashSeed;
    private static MqttDisconnect packet;
    final int packetFlags;

    MqttDisconnect(int packetFlags) {
        this.packetFlags = packetFlags;
    }

    public static MqttDisconnect packet() {
        if (packet == null) {
            packet = new MqttDisconnect(0);
        }
        return packet;
    }

    public static MqttDisconnect from(int packetFlags) {
        if (packetFlags == 0) {
            return MqttDisconnect.packet();
        }
        return new MqttDisconnect(packetFlags);
    }

    @Override
    public int packetType() {
        return 14;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttDisconnect packetFlags(int packetFlags) {
        return new MqttDisconnect(packetFlags);
    }

    @Override
    int bodySize(MqttEncoder mqtt) {
        return 0;
    }

    public Encoder<?, MqttDisconnect> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.disconnectEncoder(this);
    }

    public Encoder<?, MqttDisconnect> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodeDisconnect(this, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttDisconnect) {
            MqttDisconnect that = (MqttDisconnect)other;
            return this.packetFlags == that.packetFlags;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttDisconnect.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttDisconnect").write(46).write("packet").write(40).write(41);
        if (this.packetFlags != 0) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

