/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttDisconnect;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttException;

final class MqttDisconnectEncoder
extends Encoder<Object, MqttDisconnect> {
    final MqttEncoder mqtt;
    final MqttDisconnect packet;
    final int length;
    final int remaining;
    final int step;

    MqttDisconnectEncoder(MqttEncoder mqtt, MqttDisconnect packet, int length, int remaining, int step) {
        this.mqtt = mqtt;
        this.packet = packet;
        this.length = length;
        this.remaining = remaining;
        this.step = step;
    }

    MqttDisconnectEncoder(MqttEncoder mqtt, MqttDisconnect packet) {
        this(mqtt, packet, 0, 0, 1);
    }

    static Encoder<Object, MqttDisconnect> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttDisconnect packet, int length, int remaining, int step) {
        if (step == 1 && output.isCont()) {
            remaining = length = packet.bodySize(mqtt);
            output = output.write(packet.packetType() << 4 | packet.packetFlags & 0xF);
            step = 2;
        }
        while (step >= 2 && step <= 5 && output.isCont()) {
            int b = length & 0x7F;
            if ((length >>>= 7) > 0) {
                b |= 0x80;
            }
            output = output.write(b);
            if (length == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return MqttDisconnectEncoder.error((Throwable)new MqttException("packet length too long: " + remaining));
        }
        if (step == 6 && remaining == 0) {
            return MqttDisconnectEncoder.done((Object)packet);
        }
        if (remaining < 0) {
            return MqttDisconnectEncoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (output.isDone()) {
            return MqttDisconnectEncoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return MqttDisconnectEncoder.error((Throwable)output.trap());
        }
        return new MqttDisconnectEncoder(mqtt, packet, length, remaining, step);
    }

    static Encoder<Object, MqttDisconnect> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttDisconnect packet) {
        return MqttDisconnectEncoder.encode(output, mqtt, packet, 0, 0, 1);
    }

    public Encoder<Object, MqttDisconnect> pull(OutputBuffer<?> output) {
        return MqttDisconnectEncoder.encode(output, this.mqtt, this.packet, this.length, this.remaining, this.step);
    }
}

