/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.InputBuffer;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttPacket;

final class MqttPacketDecoder<T>
extends Decoder<MqttPacket<T>> {
    final MqttDecoder mqtt;
    final Decoder<T> content;

    MqttPacketDecoder(MqttDecoder mqtt, Decoder<T> content) {
        this.mqtt = mqtt;
        this.content = content;
    }

    static <T> Decoder<MqttPacket<T>> decode(InputBuffer input, MqttDecoder mqtt, Decoder<T> content) {
        if (input.isCont()) {
            int packetType = (input.head() & 0xF0) >>> 4;
            return mqtt.decodePacketType(packetType, content, input);
        }
        return new MqttPacketDecoder<T>(mqtt, content);
    }

    public Decoder<MqttPacket<T>> feed(InputBuffer input) {
        return MqttPacketDecoder.decode(input, this.mqtt, this.content);
    }
}

