/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.util.Murmur3;

public final class MqttPubComp
extends MqttPacket<Object>
implements Debug {
    private static int hashSeed;
    final int packetFlags;
    final int packetId;

    MqttPubComp(int packetFlags, int packetId) {
        this.packetFlags = packetFlags;
        this.packetId = packetId;
    }

    public static MqttPubComp from(int packetFlags, int packetId) {
        return new MqttPubComp(packetFlags, packetId);
    }

    public static MqttPubComp from(int packetId) {
        return new MqttPubComp(0, packetId);
    }

    @Override
    public int packetType() {
        return 7;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttPubComp packetFlags(int packetFlags) {
        return new MqttPubComp(packetFlags, this.packetId);
    }

    public int packetId() {
        return this.packetId;
    }

    public MqttPubComp packetId(int packetId) {
        return new MqttPubComp(this.packetFlags, packetId);
    }

    @Override
    int bodySize(MqttEncoder mqtt) {
        return 2;
    }

    public Encoder<?, MqttPubComp> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.pubCompEncoder(this);
    }

    public Encoder<?, MqttPubComp> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodePubComp(this, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttPubComp) {
            MqttPubComp that = (MqttPubComp)other;
            return this.packetFlags == that.packetFlags && this.packetId == that.packetId;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttPubComp.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.packetId));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttPubComp").write(46).write("from").write(40).debug((Object)this.packetId).write(41);
        if (this.packetFlags != 0) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

