/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.util.Murmur3;

public final class MqttPubRel
extends MqttPacket<Object>
implements Debug {
    private static int hashSeed;
    final int packetFlags;
    final int packetId;

    MqttPubRel(int packetFlags, int packetId) {
        this.packetFlags = packetFlags;
        this.packetId = packetId;
    }

    public static MqttPubRel from(int packetFlags, int packetId) {
        return new MqttPubRel(packetFlags, packetId);
    }

    public static MqttPubRel from(int packetId) {
        return new MqttPubRel(2, packetId);
    }

    @Override
    public int packetType() {
        return 6;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttPubRel packetFlags(int packetFlags) {
        return new MqttPubRel(packetFlags, this.packetId);
    }

    public int packetId() {
        return this.packetId;
    }

    public MqttPubRel packetId(int packetId) {
        return new MqttPubRel(this.packetFlags, packetId);
    }

    @Override
    int bodySize(MqttEncoder mqtt) {
        return 2;
    }

    public Encoder<?, MqttPubRel> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.pubRelEncoder(this);
    }

    public Encoder<?, MqttPubRel> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodePubRel(this, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttPubRel) {
            MqttPubRel that = (MqttPubRel)other;
            return this.packetFlags == that.packetFlags && this.packetId == that.packetId;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttPubRel.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.packetId));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttPubRel").write(46).write("from").write(40).debug((Object)this.packetId).write(41);
        if (this.packetFlags != 2) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

