/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.collections.FingerTrieSeq;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.mqtt.MqttSubStatus;
import swim.util.Murmur3;

public final class MqttSubAck
extends MqttPacket<Object>
implements Debug {
    private static int hashSeed;
    final int packetFlags;
    final int packetId;
    final FingerTrieSeq<MqttSubStatus> subscriptions;

    MqttSubAck(int packetFlags, int packetId, FingerTrieSeq<MqttSubStatus> subscriptions) {
        this.packetFlags = packetFlags;
        this.packetId = packetId;
        this.subscriptions = subscriptions;
    }

    public static MqttSubAck from(int packetFlags, int packetId, FingerTrieSeq<MqttSubStatus> subscriptions) {
        return new MqttSubAck(packetFlags, packetId, subscriptions);
    }

    public static MqttSubAck from(int packetId, FingerTrieSeq<MqttSubStatus> subscriptions) {
        return new MqttSubAck(0, packetId, subscriptions);
    }

    public static MqttSubAck from(int packetId, MqttSubStatus ... subscriptions) {
        return new MqttSubAck(0, packetId, (FingerTrieSeq<MqttSubStatus>)FingerTrieSeq.of((Object[])subscriptions));
    }

    public static MqttSubAck from(int packetId) {
        return new MqttSubAck(0, packetId, (FingerTrieSeq<MqttSubStatus>)FingerTrieSeq.empty());
    }

    @Override
    public int packetType() {
        return 9;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttSubAck packetFlags(int packetFlags) {
        return new MqttSubAck(packetFlags, this.packetId, this.subscriptions);
    }

    public int packetId() {
        return this.packetId;
    }

    public MqttSubAck packetId(int packetId) {
        return new MqttSubAck(this.packetFlags, packetId, this.subscriptions);
    }

    public FingerTrieSeq<MqttSubStatus> subscriptions() {
        return this.subscriptions;
    }

    public MqttSubAck subscriptions(FingerTrieSeq<MqttSubStatus> subscriptions) {
        return new MqttSubAck(this.packetFlags, this.packetId, subscriptions);
    }

    public MqttSubAck subscriptions(MqttSubStatus ... subscriptions) {
        return new MqttSubAck(this.packetFlags, this.packetId, (FingerTrieSeq<MqttSubStatus>)FingerTrieSeq.of((Object[])subscriptions));
    }

    public MqttSubAck subscription(MqttSubStatus subscription) {
        return new MqttSubAck(this.packetFlags, this.packetId, (FingerTrieSeq<MqttSubStatus>)this.subscriptions.appended((Object)subscription));
    }

    @Override
    int bodySize(MqttEncoder mqtt) {
        return 2 + this.subscriptions.size();
    }

    public Encoder<?, MqttSubAck> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.subAckEncoder(this);
    }

    public Encoder<?, MqttSubAck> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodeSubAck(this, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttSubAck) {
            MqttSubAck that = (MqttSubAck)other;
            return this.packetFlags == that.packetFlags && this.packetId == that.packetId && this.subscriptions.equals(that.subscriptions);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttSubAck.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.packetId), (int)this.subscriptions.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttSubAck").write(46).write("from").write(40).debug((Object)this.packetId).write(41);
        if (this.packetFlags != 0) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
        int n = this.subscriptions.size();
        for (int i = 0; i < n; ++i) {
            output = output.write(46).write("subscription").write(40).debug(this.subscriptions.get(i)).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

