/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.collections.FingerTrieSeq;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttSubscribe;
import swim.mqtt.MqttSubscription;

final class MqttSubscribeDecoder
extends Decoder<MqttSubscribe> {
    final MqttDecoder mqtt;
    final int packetFlags;
    final int packetId;
    final FingerTrieSeq<MqttSubscription> subscriptions;
    final Decoder<MqttSubscription> subscription;
    final int remaining;
    final int step;

    MqttSubscribeDecoder(MqttDecoder mqtt, int packetFlags, int packetId, FingerTrieSeq<MqttSubscription> subscriptions, Decoder<MqttSubscription> subscription, int remaining, int step) {
        this.mqtt = mqtt;
        this.packetFlags = packetFlags;
        this.remaining = remaining;
        this.packetId = packetId;
        this.subscriptions = subscriptions;
        this.subscription = subscription;
        this.step = step;
    }

    MqttSubscribeDecoder(MqttDecoder mqtt) {
        this(mqtt, 0, 0, (FingerTrieSeq<MqttSubscription>)FingerTrieSeq.empty(), null, 0, 1);
    }

    static Decoder<MqttSubscribe> decode(InputBuffer input, MqttDecoder mqtt, int packetFlags, int packetId, FingerTrieSeq<MqttSubscription> subscriptions, Decoder<MqttSubscription> subscription, int remaining, int step) {
        if (step == 1 && input.isCont()) {
            packetFlags = input.head() & 0xF;
            input = input.step();
            step = 2;
        }
        while (step >= 2 && step <= 5 && input.isCont()) {
            int b = input.head();
            input = input.step();
            remaining |= (b & 0x7F) << 7 * (step - 2);
            if ((b & 0x80) == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return MqttSubscribeDecoder.error((Throwable)new MqttException("packet length too long"));
        }
        if (step == 6 && remaining > 0 && input.isCont()) {
            packetId = input.head() << 8;
            input = input.step();
            --remaining;
            step = 7;
        }
        if (step == 7 && remaining > 0 && input.isCont()) {
            packetId |= input.head();
            input = input.step();
            step = --remaining > 0 ? 8 : 9;
        }
        while (step == 8 && remaining > 0 && input.isCont()) {
            int inputStart = input.index();
            int inputLimit = input.limit();
            int inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            boolean inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            subscription = subscription == null ? mqtt.decodeSubscription(input) : subscription.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (subscription.isDone()) {
                subscriptions = subscriptions.appended((Object)((MqttSubscription)subscription.bind()));
                subscription = null;
                if (remaining != 0) continue;
                step = 9;
                break;
            }
            if (!subscription.isError()) continue;
            return subscription.asError();
        }
        if (step == 9 && remaining == 0) {
            return MqttSubscribeDecoder.done((Object)mqtt.subscribe(packetFlags, packetId, subscriptions));
        }
        if (remaining < 0) {
            return MqttSubscribeDecoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (input.isDone()) {
            return MqttSubscribeDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return MqttSubscribeDecoder.error((Throwable)input.trap());
        }
        return new MqttSubscribeDecoder(mqtt, packetFlags, packetId, (FingerTrieSeq<MqttSubscription>)subscriptions, (Decoder<MqttSubscription>)subscription, remaining, step);
    }

    static Decoder<MqttSubscribe> decode(InputBuffer input, MqttDecoder mqtt) {
        return MqttSubscribeDecoder.decode(input, mqtt, 0, 0, (FingerTrieSeq<MqttSubscription>)FingerTrieSeq.empty(), null, 0, 1);
    }

    public Decoder<MqttSubscribe> feed(InputBuffer input) {
        return MqttSubscribeDecoder.decode(input, this.mqtt, this.packetFlags, this.packetId, this.subscriptions, this.subscription, this.remaining, this.step);
    }
}

