/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttUnsubAck;

final class MqttUnsubAckDecoder
extends Decoder<MqttUnsubAck> {
    final MqttDecoder mqtt;
    final int packetFlags;
    final int packetId;
    final int remaining;
    final int step;

    MqttUnsubAckDecoder(MqttDecoder mqtt, int packetFlags, int packetId, int remaining, int step) {
        this.mqtt = mqtt;
        this.packetFlags = packetFlags;
        this.packetId = packetId;
        this.remaining = remaining;
        this.step = step;
    }

    MqttUnsubAckDecoder(MqttDecoder mqtt) {
        this(mqtt, 0, 0, 0, 1);
    }

    static Decoder<MqttUnsubAck> decode(InputBuffer input, MqttDecoder mqtt, int packetFlags, int packetId, int remaining, int step) {
        if (step == 1 && input.isCont()) {
            packetFlags = input.head() & 0xF;
            input = input.step();
            step = 2;
        }
        while (step >= 2 && step <= 5 && input.isCont()) {
            int b = input.head();
            input = input.step();
            remaining |= (b & 0x7F) << 7 * (step - 2);
            if ((b & 0x80) == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return MqttUnsubAckDecoder.error((Throwable)new MqttException("packet length too long"));
        }
        if (step == 6 && remaining > 0 && input.isCont()) {
            packetId = input.head() << 8;
            input = input.step();
            --remaining;
            step = 7;
        }
        if (step == 7 && remaining > 0 && input.isCont()) {
            packetId |= input.head();
            input = input.step();
            --remaining;
            step = 8;
        }
        if (step == 8 && remaining == 0) {
            return MqttUnsubAckDecoder.done((Object)mqtt.unsubAck(packetFlags, packetId));
        }
        if (remaining < 0) {
            return MqttUnsubAckDecoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (input.isDone()) {
            return MqttUnsubAckDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return MqttUnsubAckDecoder.error((Throwable)input.trap());
        }
        return new MqttUnsubAckDecoder(mqtt, packetFlags, packetId, remaining, step);
    }

    static Decoder<MqttUnsubAck> decode(InputBuffer input, MqttDecoder mqtt) {
        return MqttUnsubAckDecoder.decode(input, mqtt, 0, 0, 0, 1);
    }

    public Decoder<MqttUnsubAck> feed(InputBuffer input) {
        return MqttUnsubAckDecoder.decode(input, this.mqtt, this.packetFlags, this.packetId, this.remaining, this.step);
    }
}

