/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.collections.FingerTrieSeq;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.util.Murmur3;

public final class MqttUnsubscribe
extends MqttPacket<Object>
implements Debug {
    private static int hashSeed;
    final int packetFlags;
    final int packetId;
    final FingerTrieSeq<String> topicNames;

    MqttUnsubscribe(int packetFlags, int packetId, FingerTrieSeq<String> topicNames) {
        this.packetFlags = packetFlags;
        this.packetId = packetId;
        this.topicNames = topicNames;
    }

    public static MqttUnsubscribe from(int packetFlags, int packetId, FingerTrieSeq<String> topicNames) {
        return new MqttUnsubscribe(packetFlags, packetId, topicNames);
    }

    public static MqttUnsubscribe from(int packetId, FingerTrieSeq<String> topicNames) {
        return new MqttUnsubscribe(2, packetId, topicNames);
    }

    public static MqttUnsubscribe from(int packetId, String ... topicNames) {
        return new MqttUnsubscribe(2, packetId, (FingerTrieSeq<String>)FingerTrieSeq.of((Object[])topicNames));
    }

    public static MqttUnsubscribe from(int packetId) {
        return new MqttUnsubscribe(2, packetId, (FingerTrieSeq<String>)FingerTrieSeq.empty());
    }

    @Override
    public int packetType() {
        return 10;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttUnsubscribe packetFlags(int packetFlags) {
        return new MqttUnsubscribe(packetFlags, this.packetId, this.topicNames);
    }

    public int packetId() {
        return this.packetId;
    }

    public MqttUnsubscribe packetId(int packetId) {
        return new MqttUnsubscribe(this.packetFlags, packetId, this.topicNames);
    }

    public FingerTrieSeq<String> topicNames() {
        return this.topicNames;
    }

    public MqttUnsubscribe topicNames(FingerTrieSeq<String> topicNames) {
        return new MqttUnsubscribe(this.packetFlags, this.packetId, topicNames);
    }

    public MqttUnsubscribe topicNames(String ... topicNames) {
        return new MqttUnsubscribe(this.packetFlags, this.packetId, (FingerTrieSeq<String>)FingerTrieSeq.of((Object[])topicNames));
    }

    public MqttUnsubscribe topicName(String topicName) {
        return new MqttUnsubscribe(this.packetFlags, this.packetId, (FingerTrieSeq<String>)this.topicNames.appended((Object)topicName));
    }

    @Override
    int bodySize(MqttEncoder mqtt) {
        int size = 2;
        int n = this.topicNames.size();
        for (int i = 0; i < n; ++i) {
            size += mqtt.sizeOfString((String)this.topicNames.get(i));
        }
        return size;
    }

    public Encoder<?, MqttUnsubscribe> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.unsubscribeEncoder(this);
    }

    public Encoder<?, MqttUnsubscribe> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodeUnsubscribe(this, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttUnsubscribe) {
            MqttUnsubscribe that = (MqttUnsubscribe)other;
            return this.packetFlags == that.packetFlags && this.packetId == that.packetId && this.topicNames.equals(that.topicNames);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttUnsubscribe.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.packetId), (int)this.topicNames.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttUnsubscribe").write(46).write("from").write(40).debug((Object)this.packetId).write(41);
        if (this.packetFlags != 2) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
        int n = this.topicNames.size();
        for (int i = 0; i < n; ++i) {
            output = output.write(46).write("topicName").write(40).debug(this.topicNames.get(i)).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

