/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttSubscription;

final class MqttSubscriptionDecoder
extends Decoder<MqttSubscription> {
    final MqttDecoder mqtt;
    final Decoder<String> topicName;
    final int step;

    MqttSubscriptionDecoder(MqttDecoder mqtt, Decoder<String> topicName, int step) {
        this.mqtt = mqtt;
        this.topicName = topicName;
        this.step = step;
    }

    MqttSubscriptionDecoder(MqttDecoder mqtt) {
        this(mqtt, null, 1);
    }

    public Decoder<MqttSubscription> feed(InputBuffer input) {
        return MqttSubscriptionDecoder.decode(input, this.mqtt, this.topicName, this.step);
    }

    static Decoder<MqttSubscription> decode(InputBuffer input, MqttDecoder mqtt, Decoder<String> topicName, int step) {
        if (step == 1) {
            if ((topicName = topicName == null ? mqtt.decodeString(input) : topicName.feed(input)).isDone()) {
                step = 2;
            } else if (topicName.isError()) {
                return topicName.asError();
            }
        }
        if (step == 2 && input.isCont()) {
            int flags = input.head();
            input = input.step();
            return MqttSubscriptionDecoder.done((Object)mqtt.subscription((String)topicName.bind(), flags));
        }
        if (input.isDone()) {
            return MqttSubscriptionDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return MqttSubscriptionDecoder.error((Throwable)input.trap());
        }
        return new MqttSubscriptionDecoder(mqtt, (Decoder<String>)topicName, step);
    }

    static Decoder<MqttSubscription> decode(InputBuffer input, MqttDecoder mqtt) {
        return MqttSubscriptionDecoder.decode(input, mqtt, null, 1);
    }
}

