/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Binary;
import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.Input;
import swim.codec.InputBuffer;
import swim.codec.Output;
import swim.structure.Data;

final class MqttDataDecoder
extends Decoder<Data> {
    final Decoder<byte[]> decoder;
    final int remaining;
    final int step;

    MqttDataDecoder(Decoder<byte[]> decoder, int remaining, int step) {
        this.decoder = decoder;
        this.remaining = remaining;
        this.step = step;
    }

    MqttDataDecoder() {
        this(null, 0, 1);
    }

    public Decoder<Data> feed(InputBuffer input) {
        return MqttDataDecoder.decode(input, this.decoder, this.remaining, this.step);
    }

    static Decoder<Data> decode(InputBuffer input, Decoder<byte[]> decoder, int remaining, int step) {
        if (step == 1 && input.isCont()) {
            remaining = input.head() << 8;
            input = input.step();
            step = 2;
        }
        if (step == 2 && input.isCont()) {
            remaining |= input.head();
            input = input.step();
            step = 3;
        }
        if (step == 3) {
            int inputStart = input.index();
            int inputLimit = input.limit();
            int inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            boolean inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            decoder = decoder == null ? Binary.parseOutput((Output)Binary.byteArrayOutput((int)remaining), (Input)input) : decoder.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (decoder.isDone()) {
                return MqttDataDecoder.done((Object)Data.wrap((byte[])((byte[])decoder.bind())));
            }
            if (decoder.isError()) {
                return decoder.asError();
            }
        }
        if (input.isDone()) {
            return MqttDataDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return MqttDataDecoder.error((Throwable)input.trap());
        }
        return new MqttDataDecoder((Decoder<byte[]>)decoder, remaining, step);
    }

    static Decoder<Data> decode(InputBuffer input) {
        return MqttDataDecoder.decode(input, null, 0, 1);
    }
}

