/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.mqtt.MqttConnectPacket;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttException;
import swim.structure.Data;

final class MqttConnectPacketDecoder
extends Decoder<MqttConnectPacket> {
    final MqttDecoder mqtt;
    final int packetFlags;
    final Decoder<String> protocolNameDecoder;
    final int protocolLevel;
    final int connectFlags;
    final int keepAlive;
    final Decoder<String> clientIdDecoder;
    final Decoder<String> willTopicDecoder;
    final Decoder<Data> willMessageDecoder;
    final Decoder<String> usernameDecoder;
    final Decoder<Data> passwordDecoder;
    final int remaining;
    final int step;

    MqttConnectPacketDecoder(MqttDecoder mqtt, int packetFlags, Decoder<String> protocolNameDecoder, int protocolLevel, int connectFlags, int keepAlive, Decoder<String> clientIdDecoder, Decoder<String> willTopicDecoder, Decoder<Data> willMessageDecoder, Decoder<String> usernameDecoder, Decoder<Data> passwordDecoder, int remaining, int step) {
        this.mqtt = mqtt;
        this.packetFlags = packetFlags;
        this.remaining = remaining;
        this.protocolNameDecoder = protocolNameDecoder;
        this.protocolLevel = protocolLevel;
        this.connectFlags = connectFlags;
        this.keepAlive = keepAlive;
        this.clientIdDecoder = clientIdDecoder;
        this.willTopicDecoder = willTopicDecoder;
        this.willMessageDecoder = willMessageDecoder;
        this.usernameDecoder = usernameDecoder;
        this.passwordDecoder = passwordDecoder;
        this.step = step;
    }

    MqttConnectPacketDecoder(MqttDecoder mqtt) {
        this(mqtt, 0, null, 0, 0, 0, null, null, null, null, null, 0, 1);
    }

    public Decoder<MqttConnectPacket> feed(InputBuffer input) {
        return MqttConnectPacketDecoder.decode(input, this.mqtt, this.packetFlags, this.protocolNameDecoder, this.protocolLevel, this.connectFlags, this.keepAlive, this.clientIdDecoder, this.willTopicDecoder, this.willMessageDecoder, this.usernameDecoder, this.passwordDecoder, this.remaining, this.step);
    }

    static Decoder<MqttConnectPacket> decode(InputBuffer input, MqttDecoder mqtt, int packetFlags, Decoder<String> protocolNameDecoder, int protocolLevel, int connectFlags, int keepAlive, Decoder<String> clientIdDecoder, Decoder<String> willTopicDecoder, Decoder<Data> willMessageDecoder, Decoder<String> usernameDecoder, Decoder<Data> passwordDecoder, int remaining, int step) {
        boolean inputPart;
        int inputRemaining;
        int inputLimit;
        int inputStart;
        if (step == 1 && input.isCont()) {
            packetFlags = input.head() & 0xF;
            input = input.step();
            step = 2;
        }
        while (step >= 2 && step <= 5 && input.isCont()) {
            int b = input.head();
            input = input.step();
            remaining |= (b & 0x7F) << 7 * (step - 2);
            if ((b & 0x80) == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return Decoder.error((Throwable)new MqttException("packet length too long"));
        }
        if (step == 6) {
            inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            protocolNameDecoder = protocolNameDecoder == null ? mqtt.decodeString(input) : protocolNameDecoder.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (protocolNameDecoder.isDone()) {
                step = 7;
            } else if (protocolNameDecoder.isError()) {
                return protocolNameDecoder.asError();
            }
        }
        if (step == 7 && remaining > 0 && input.isCont()) {
            protocolLevel = input.head();
            input = input.step();
            --remaining;
            step = 8;
        }
        if (step == 8 && remaining > 0 && input.isCont()) {
            connectFlags = input.head();
            input = input.step();
            --remaining;
            step = 9;
        }
        if (step == 9 && remaining > 0 && input.isCont()) {
            keepAlive = input.head() << 8;
            input = input.step();
            --remaining;
            step = 10;
        }
        if (step == 10 && remaining > 0 && input.isCont()) {
            keepAlive |= input.head();
            input = input.step();
            --remaining;
            step = 11;
        }
        if (step == 11) {
            inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            clientIdDecoder = clientIdDecoder == null ? mqtt.decodeString(input) : clientIdDecoder.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (clientIdDecoder.isDone()) {
                step = (connectFlags & 4) != 0 ? 12 : ((connectFlags & 0x80) != 0 ? 14 : ((connectFlags & 0x40) != 0 ? 15 : 16));
            } else if (clientIdDecoder.isError()) {
                return clientIdDecoder.asError();
            }
        }
        if (step == 12) {
            inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            willTopicDecoder = willTopicDecoder == null ? mqtt.decodeString(input) : willTopicDecoder.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (willTopicDecoder.isDone()) {
                step = 13;
            } else if (willTopicDecoder.isError()) {
                return willTopicDecoder.asError();
            }
        }
        if (step == 13) {
            inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            willMessageDecoder = willMessageDecoder == null ? mqtt.decodeData(input) : willMessageDecoder.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (willMessageDecoder.isDone()) {
                step = (connectFlags & 0x80) != 0 ? 14 : ((connectFlags & 0x40) != 0 ? 15 : 16);
            } else if (willMessageDecoder.isError()) {
                return willMessageDecoder.asError();
            }
        }
        if (step == 14) {
            inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            usernameDecoder = usernameDecoder == null ? mqtt.decodeString(input) : usernameDecoder.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (usernameDecoder.isDone()) {
                step = (connectFlags & 0x40) != 0 ? 15 : 16;
            } else if (usernameDecoder.isError()) {
                return usernameDecoder.asError();
            }
        }
        if (step == 15) {
            inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            passwordDecoder = passwordDecoder == null ? mqtt.decodeData(input) : passwordDecoder.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (passwordDecoder.isDone()) {
                step = 16;
            } else if (passwordDecoder.isError()) {
                return passwordDecoder.asError();
            }
        }
        if (step == 16 && remaining == 0) {
            return Decoder.done((Object)mqtt.connectPacket(packetFlags, (String)protocolNameDecoder.bind(), protocolLevel, connectFlags, keepAlive, clientIdDecoder != null ? (String)clientIdDecoder.bind() : null, willTopicDecoder != null ? (String)willTopicDecoder.bind() : null, willMessageDecoder != null ? (Data)willMessageDecoder.bind() : null, usernameDecoder != null ? (String)usernameDecoder.bind() : null, passwordDecoder != null ? (Data)passwordDecoder.bind() : null));
        }
        if (remaining < 0) {
            return Decoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (input.isDone()) {
            return Decoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return Decoder.error((Throwable)input.trap());
        }
        return new MqttConnectPacketDecoder(mqtt, packetFlags, (Decoder<String>)protocolNameDecoder, protocolLevel, connectFlags, keepAlive, (Decoder<String>)clientIdDecoder, (Decoder<String>)willTopicDecoder, (Decoder<Data>)willMessageDecoder, (Decoder<String>)usernameDecoder, (Decoder<Data>)passwordDecoder, remaining, step);
    }

    static Decoder<MqttConnectPacket> decode(InputBuffer input, MqttDecoder mqtt) {
        return MqttConnectPacketDecoder.decode(input, mqtt, 0, null, 0, 0, 0, null, null, null, null, null, 0, 1);
    }
}

