/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.InputBuffer;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttPacket;

final class MqttPacketDecoder<T>
extends Decoder<MqttPacket<T>> {
    final MqttDecoder mqtt;
    final Decoder<T> payloadDecoder;

    MqttPacketDecoder(MqttDecoder mqtt, Decoder<T> payloadDecoder) {
        this.mqtt = mqtt;
        this.payloadDecoder = payloadDecoder;
    }

    public Decoder<MqttPacket<T>> feed(InputBuffer input) {
        return MqttPacketDecoder.decode(input, this.mqtt, this.payloadDecoder);
    }

    static <T> Decoder<MqttPacket<T>> decode(InputBuffer input, MqttDecoder mqtt, Decoder<T> payloadDecoder) {
        if (input.isCont()) {
            int packetType = (input.head() & 0xF0) >>> 4;
            return mqtt.decodePacketType(input, packetType, payloadDecoder);
        }
        return new MqttPacketDecoder<T>(mqtt, payloadDecoder);
    }
}

