/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.codec.Utf8;
import swim.mqtt.MqttException;

final class MqttStringEncoder
extends Encoder<String, String> {
    final String string;
    final Encoder<?, ?> encoder;
    final int length;
    final int step;

    MqttStringEncoder(String string, Encoder<?, ?> encoder, int length, int step) {
        this.string = string;
        this.encoder = encoder;
        this.length = length;
        this.step = step;
    }

    MqttStringEncoder(String string) {
        this(string, null, 0, 1);
    }

    public Encoder<String, String> feed(String string) {
        return new MqttStringEncoder(string, null, 0, 1);
    }

    public Encoder<String, String> pull(OutputBuffer<?> output) {
        return MqttStringEncoder.encode(output, this.string, this.encoder, this.length, this.step);
    }

    static int sizeOf(String string) {
        return 2 + Utf8.sizeOf((String)string);
    }

    static Encoder<String, String> encode(OutputBuffer<?> output, String string, Encoder<?, ?> encoder, int length, int step) {
        if (step == 1 && output.isCont()) {
            length = Utf8.sizeOf((String)string);
            if (length > 65535) {
                return Encoder.error((Throwable)new MqttException("string too long (" + length + " bytes)"));
            }
            output = output.write(length >>> 8);
            step = 2;
        }
        if (step == 2 && output.isCont()) {
            output = output.write(length);
            step = 3;
        }
        if (step == 3) {
            if ((encoder = encoder == null ? Utf8.writeString((Output)output, (Object)string) : encoder.pull(output)).isDone()) {
                return Encoder.done((Object)string);
            }
            if (encoder.isError()) {
                return encoder.asError();
            }
        }
        if (output.isDone()) {
            return Encoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return Encoder.error((Throwable)output.trap());
        }
        return new MqttStringEncoder(string, (Encoder<?, ?>)encoder, length, step);
    }

    static Encoder<String, String> encode(OutputBuffer<?> output, String string) {
        return MqttStringEncoder.encode(output, string, null, 0, 1);
    }
}

