/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.collections.FingerTrieSeq;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.mqtt.MqttQoS;
import swim.mqtt.MqttSubscription;
import swim.util.Murmur3;

public final class MqttSubscribePacket
extends MqttPacket<Object>
implements Debug {
    final int packetFlags;
    final int packetId;
    final FingerTrieSeq<MqttSubscription> subscriptions;
    private static int hashSeed;

    MqttSubscribePacket(int packetFlags, int packetId, FingerTrieSeq<MqttSubscription> subscriptions) {
        this.packetFlags = packetFlags;
        this.packetId = packetId;
        this.subscriptions = subscriptions;
    }

    @Override
    public int packetType() {
        return 8;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttSubscribePacket packetFlags(int packetFlags) {
        return new MqttSubscribePacket(packetFlags, this.packetId, this.subscriptions);
    }

    public int packetId() {
        return this.packetId;
    }

    public MqttSubscribePacket packetId(int packetId) {
        return new MqttSubscribePacket(this.packetFlags, packetId, this.subscriptions);
    }

    public FingerTrieSeq<MqttSubscription> subscriptions() {
        return this.subscriptions;
    }

    public MqttSubscribePacket subscriptions(FingerTrieSeq<MqttSubscription> subscriptions) {
        return new MqttSubscribePacket(this.packetFlags, this.packetId, subscriptions);
    }

    public MqttSubscribePacket subscriptions(MqttSubscription ... subscriptions) {
        return new MqttSubscribePacket(this.packetFlags, this.packetId, (FingerTrieSeq<MqttSubscription>)FingerTrieSeq.of((Object[])subscriptions));
    }

    public MqttSubscribePacket subscription(MqttSubscription subscription) {
        return new MqttSubscribePacket(this.packetFlags, this.packetId, (FingerTrieSeq<MqttSubscription>)this.subscriptions.appended((Object)subscription));
    }

    public MqttSubscribePacket subscription(String topicName, MqttQoS qos) {
        return this.subscription(MqttSubscription.create(topicName, qos));
    }

    public MqttSubscribePacket subscription(String topicName) {
        return this.subscription(MqttSubscription.create(topicName));
    }

    @Override
    int variableHeaderSize(MqttEncoder mqtt) {
        int size = 2;
        int n = this.subscriptions.size();
        for (int i = 0; i < n; ++i) {
            size += ((MqttSubscription)this.subscriptions.get(i)).mqttSize(mqtt);
        }
        return size;
    }

    @Override
    public Encoder<?, MqttSubscribePacket> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.subscribePacketEncoder(this);
    }

    @Override
    public Encoder<?, MqttSubscribePacket> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodeSubscribePacket(output, this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttSubscribePacket) {
            MqttSubscribePacket that = (MqttSubscribePacket)other;
            return this.packetFlags == that.packetFlags && this.packetId == that.packetId && this.subscriptions.equals(that.subscriptions);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttSubscribePacket.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.packetId), (int)this.subscriptions.hashCode()));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("MqttSubscribePacket").write(46).write("create").write(40).debug((Object)this.packetId).write(41);
        if (this.packetFlags != 2) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
        int n = this.subscriptions.size();
        for (int i = 0; i < n; ++i) {
            MqttSubscription subscription = (MqttSubscription)this.subscriptions.get(i);
            output = output.write(46).write("subscription").write(40).debug((Object)subscription.topicName);
            if ((subscription.flags & 3) != 0) {
                output = output.write(", ").debug((Object)subscription.qos());
            }
            output = output.write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttSubscribePacket create(int packetFlags, int packetId, FingerTrieSeq<MqttSubscription> subscriptions) {
        return new MqttSubscribePacket(packetFlags, packetId, subscriptions);
    }

    public static MqttSubscribePacket create(int packetId, FingerTrieSeq<MqttSubscription> subscriptions) {
        return new MqttSubscribePacket(2, packetId, subscriptions);
    }

    public static MqttSubscribePacket create(int packetId, MqttSubscription ... subscriptions) {
        return new MqttSubscribePacket(2, packetId, (FingerTrieSeq<MqttSubscription>)FingerTrieSeq.of((Object[])subscriptions));
    }

    public static MqttSubscribePacket create(int packetId) {
        return new MqttSubscribePacket(2, packetId, (FingerTrieSeq<MqttSubscription>)FingerTrieSeq.empty());
    }
}

