/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.Mqtt;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttQoS;
import swim.util.Murmur3;

public final class MqttSubscription
implements Debug {
    final String topicName;
    final int flags;
    private static int hashSeed;
    static final int QOS_MASK = 3;

    MqttSubscription(String topicName, int flags) {
        this.topicName = topicName;
        this.flags = flags;
    }

    public String topicName() {
        return this.topicName;
    }

    public MqttSubscription topicName(String topicName) {
        return new MqttSubscription(topicName, this.flags);
    }

    public int flags() {
        return this.flags;
    }

    public MqttQoS qos() {
        return MqttQoS.from(this.flags & 3);
    }

    public MqttSubscription qos(MqttQoS qos) {
        int flags = this.flags & 0xFFFFFFFC | qos.code;
        return new MqttSubscription(this.topicName, flags);
    }

    public int mqttSize(MqttEncoder mqtt) {
        return mqtt.sizeOfSubscription(this);
    }

    public Encoder<?, MqttSubscription> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.subscriptionEncoder(this);
    }

    public Encoder<?, ?> mqttEncoder() {
        return this.mqttEncoder(Mqtt.standardEncoder());
    }

    public Encoder<?, MqttSubscription> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodeSubscription(output, this);
    }

    public Encoder<?, ?> encodeMqtt(OutputBuffer<?> output) {
        return this.encodeMqtt(output, Mqtt.standardEncoder());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttSubscription) {
            MqttSubscription that = (MqttSubscription)other;
            return this.topicName.equals(that.topicName) && this.flags == that.flags;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttSubscription.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.topicName.hashCode()), (int)this.flags));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("MqttSubscription").write(46).write("create").write(40).debug((Object)this.topicName);
        if ((this.flags & 3) != 0) {
            output = output.write(", ").debug((Object)this.qos());
        }
        output = output.write(41);
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttSubscription create(String topicName, int flags) {
        return new MqttSubscription(topicName, flags);
    }

    public static MqttSubscription create(String topicName, MqttQoS qos) {
        return new MqttSubscription(topicName, qos.code);
    }

    public static MqttSubscription create(String topicName) {
        return new MqttSubscription(topicName, 0);
    }
}

