/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.collections.FingerTrieSeq;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttUnsubscribePacket;

final class MqttUnsubscribePacketDecoder
extends Decoder<MqttUnsubscribePacket> {
    final MqttDecoder mqtt;
    final int packetFlags;
    final int packetId;
    final Decoder<String> topicNameDecoder;
    final FingerTrieSeq<String> topicNames;
    final int remaining;
    final int step;

    MqttUnsubscribePacketDecoder(MqttDecoder mqtt, int packetFlags, int packetId, Decoder<String> topicNameDecoder, FingerTrieSeq<String> topicNames, int remaining, int step) {
        this.mqtt = mqtt;
        this.packetFlags = packetFlags;
        this.packetId = packetId;
        this.topicNameDecoder = topicNameDecoder;
        this.topicNames = topicNames;
        this.remaining = remaining;
        this.step = step;
    }

    MqttUnsubscribePacketDecoder(MqttDecoder mqtt) {
        this(mqtt, 0, 0, null, (FingerTrieSeq<String>)FingerTrieSeq.empty(), 0, 1);
    }

    public Decoder<MqttUnsubscribePacket> feed(InputBuffer input) {
        return MqttUnsubscribePacketDecoder.decode(input, this.mqtt, this.packetFlags, this.packetId, this.topicNameDecoder, this.topicNames, this.remaining, this.step);
    }

    static Decoder<MqttUnsubscribePacket> decode(InputBuffer input, MqttDecoder mqtt, int packetFlags, int packetId, Decoder<String> topicNameDecoder, FingerTrieSeq<String> topicNames, int remaining, int step) {
        if (step == 1 && input.isCont()) {
            packetFlags = input.head() & 0xF;
            input = input.step();
            step = 2;
        }
        while (step >= 2 && step <= 5 && input.isCont()) {
            int b = input.head();
            input = input.step();
            remaining |= (b & 0x7F) << 7 * (step - 2);
            if ((b & 0x80) == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return Decoder.error((Throwable)new MqttException("packet length too long"));
        }
        if (step == 6 && remaining > 0 && input.isCont()) {
            packetId = input.head() << 8;
            input = input.step();
            --remaining;
            step = 7;
        }
        if (step == 7 && remaining > 0 && input.isCont()) {
            packetId |= input.head();
            input = input.step();
            step = --remaining > 0 ? 8 : 9;
        }
        while (step == 8 && remaining > 0 && input.isCont()) {
            int inputStart = input.index();
            int inputLimit = input.limit();
            int inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            boolean inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            topicNameDecoder = topicNameDecoder == null ? mqtt.decodeString(input) : topicNameDecoder.feed(input);
            input = input.limit(inputLimit);
            remaining -= input.index() - inputStart;
            if (topicNameDecoder.isDone()) {
                topicNames = topicNames.appended((Object)((String)topicNameDecoder.bind()));
                topicNameDecoder = null;
                if (remaining != 0) continue;
                step = 9;
                break;
            }
            if (!topicNameDecoder.isError()) continue;
            return topicNameDecoder.asError();
        }
        if (step == 9 && remaining == 0) {
            return Decoder.done((Object)mqtt.unsubscribePacket(packetFlags, packetId, topicNames));
        }
        if (remaining < 0) {
            return Decoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (input.isDone()) {
            return Decoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return Decoder.error((Throwable)input.trap());
        }
        return new MqttUnsubscribePacketDecoder(mqtt, packetFlags, packetId, (Decoder<String>)topicNameDecoder, (FingerTrieSeq<String>)topicNames, remaining, step);
    }

    static Decoder<MqttUnsubscribePacket> decode(InputBuffer input, MqttDecoder mqtt) {
        return MqttUnsubscribePacketDecoder.decode(input, mqtt, 0, 0, null, (FingerTrieSeq<String>)FingerTrieSeq.empty(), 0, 1);
    }
}

