/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.mqtt.MqttQoS;
import swim.structure.Data;
import swim.util.Murmur3;

public final class MqttConnectPacket
extends MqttPacket<Object>
implements Debug {
    final int packetFlags;
    final String protocolName;
    final int protocolLevel;
    final int connectFlags;
    final int keepAlive;
    final String clientId;
    final String willTopic;
    final Data willMessage;
    final String username;
    final Data password;
    private static int hashSeed;
    static final int CLEAN_SESSION_FLAG = 2;
    static final int WILL_FLAG = 4;
    static final int WILL_QOS_MASK = 24;
    static final int WILL_QOS_SHIFT = 3;
    static final int WILL_RETAIN_FLAG = 32;
    static final int PASSWORD_FLAG = 64;
    static final int USERNAME_FLAG = 128;

    MqttConnectPacket(int packetFlags, String protocolName, int protocolLevel, int connectFlags, int keepAlive, String clientId, String willTopic, Data willMessage, String username, Data password) {
        this.packetFlags = packetFlags;
        this.protocolName = protocolName;
        this.protocolLevel = protocolLevel;
        this.connectFlags = connectFlags;
        this.keepAlive = keepAlive;
        this.clientId = clientId;
        this.willTopic = willTopic;
        this.willMessage = willMessage != null ? willMessage.commit() : null;
        this.username = username;
        this.password = password != null ? password.commit() : null;
    }

    @Override
    public int packetType() {
        return 1;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttConnectPacket packetFlags(int packetFlags) {
        return new MqttConnectPacket(packetFlags, this.protocolName, this.protocolLevel, this.connectFlags, this.keepAlive, this.clientId, this.willTopic, this.willMessage, this.username, this.password);
    }

    public String protocolName() {
        return this.protocolName;
    }

    public MqttConnectPacket protocolName(String protocolName) {
        return new MqttConnectPacket(this.packetFlags, protocolName, this.protocolLevel, this.connectFlags, this.keepAlive, this.clientId, this.willTopic, this.willMessage, this.username, this.password);
    }

    public int protocolLevel() {
        return this.protocolLevel;
    }

    public MqttConnectPacket protocolLevel(int protocolLevel) {
        return new MqttConnectPacket(this.packetFlags, this.protocolName, protocolLevel, this.connectFlags, this.keepAlive, this.clientId, this.willTopic, this.willMessage, this.username, this.password);
    }

    public int connectFlags() {
        return this.connectFlags;
    }

    public int keepAlive() {
        return this.keepAlive;
    }

    public MqttConnectPacket keepAlive(int keepAlive) {
        return new MqttConnectPacket(this.packetFlags, this.protocolName, this.protocolLevel, this.connectFlags, keepAlive, this.clientId, this.willTopic, this.willMessage, this.username, this.password);
    }

    public String clientId() {
        return this.clientId;
    }

    public MqttConnectPacket clientId(String clientId) {
        return new MqttConnectPacket(this.packetFlags, this.protocolName, this.protocolLevel, this.connectFlags, this.keepAlive, clientId, this.willTopic, this.willMessage, this.username, this.password);
    }

    public boolean cleanSession() {
        return (this.connectFlags & 2) != 0;
    }

    public MqttConnectPacket cleanSession(boolean cleanSession) {
        int connectFlags = cleanSession ? this.connectFlags | 2 : this.connectFlags & 0xFFFFFFFD;
        return new MqttConnectPacket(this.packetFlags, this.protocolName, this.protocolLevel, connectFlags, this.keepAlive, this.clientId, this.willTopic, this.willMessage, this.username, this.password);
    }

    public String willTopic() {
        return this.willTopic;
    }

    public MqttConnectPacket willTopic(String willTopic) {
        int connectFlags = willTopic != null && this.willMessage != null ? this.connectFlags | 4 : this.connectFlags & 0xFFFFFFFB;
        return new MqttConnectPacket(this.packetFlags, this.protocolName, this.protocolLevel, connectFlags, this.keepAlive, this.clientId, willTopic, this.willMessage, this.username, this.password);
    }

    public Data willMessage() {
        return this.willMessage;
    }

    public MqttConnectPacket willMessage(Data willMessage) {
        int connectFlags = this.willTopic != null && willMessage != null ? this.connectFlags | 4 : this.connectFlags & 0xFFFFFFFB;
        return new MqttConnectPacket(this.packetFlags, this.protocolName, this.protocolLevel, connectFlags, this.keepAlive, this.clientId, this.willTopic, willMessage != null ? willMessage.commit() : null, this.username, this.password);
    }

    public MqttQoS willQoS() {
        return MqttQoS.from((this.connectFlags & 0x18) >>> 3);
    }

    public MqttConnectPacket willQoS(MqttQoS willQoS) {
        int connectFlags = this.connectFlags & 0xFFFFFFE7 | willQoS.code << 3 & 0x18;
        return new MqttConnectPacket(this.packetFlags, this.protocolName, this.protocolLevel, connectFlags, this.keepAlive, this.clientId, this.willTopic, this.willMessage, this.username, this.password);
    }

    public boolean willRetain() {
        return (this.connectFlags & 0x20) != 0;
    }

    public MqttConnectPacket willRetain(boolean willRetain) {
        int connectFlags = willRetain ? this.connectFlags | 0x20 : this.connectFlags & 0xFFFFFFDF;
        return new MqttConnectPacket(this.packetFlags, this.protocolName, this.protocolLevel, connectFlags, this.keepAlive, this.clientId, this.willTopic, this.willMessage, this.username, this.password);
    }

    public String username() {
        return this.username;
    }

    public MqttConnectPacket username(String username) {
        int connectFlags = username != null ? this.connectFlags | 0x80 : this.connectFlags & 0xFFFFFF7F;
        return new MqttConnectPacket(this.packetFlags, this.protocolName, this.protocolLevel, connectFlags, this.keepAlive, this.clientId, this.willTopic, this.willMessage, username, this.password);
    }

    public Data password() {
        return this.password;
    }

    public MqttConnectPacket password(Data password) {
        int connectFlags = password != null ? this.connectFlags | 0x40 : this.connectFlags & 0xFFFFFFBF;
        return new MqttConnectPacket(this.packetFlags, this.protocolName, this.protocolLevel, connectFlags, this.keepAlive, this.clientId, this.willTopic, this.willMessage, this.username, password != null ? password.commit() : null);
    }

    @Override
    int variableHeaderSize(MqttEncoder mqtt) {
        int size = mqtt.sizeOfString(this.protocolName) + 4;
        size += mqtt.sizeOfString(this.clientId);
        if ((this.connectFlags & 4) != 0) {
            size += mqtt.sizeOfString(this.willTopic);
            size += mqtt.sizeOfData(this.willMessage);
        }
        if ((this.connectFlags & 0x80) != 0) {
            size += mqtt.sizeOfString(this.username);
        }
        if ((this.connectFlags & 0x40) != 0) {
            size += mqtt.sizeOfData(this.password);
        }
        return size;
    }

    @Override
    public Encoder<?, MqttConnectPacket> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.connectPacketEncoder(this);
    }

    @Override
    public Encoder<?, MqttConnectPacket> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodeConnectPacket(output, this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttConnectPacket) {
            MqttConnectPacket that = (MqttConnectPacket)other;
            return this.packetFlags == that.packetFlags && this.protocolName.equals(that.protocolName) && this.protocolLevel == that.protocolLevel && this.connectFlags == that.connectFlags && this.keepAlive == that.keepAlive && this.clientId.equals(that.clientId) && (this.willTopic == null ? that.willTopic == null : this.willTopic.equals(that.willTopic)) && (this.willMessage == null ? that.willMessage == null : this.willMessage.equals((Object)that.willMessage)) && (this.username == null ? that.username == null : this.username.equals(that.username)) && (this.password == null ? that.password == null : this.password.equals((Object)that.password));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttConnectPacket.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.protocolName.hashCode()), (int)this.protocolLevel), (int)this.connectFlags), (int)this.keepAlive), (int)this.clientId.hashCode()), (int)Murmur3.hash((Object)this.willTopic)), (int)Murmur3.hash((Object)this.willMessage)), (int)Murmur3.hash((Object)this.username)), (int)Murmur3.hash((Object)this.password)));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("MqttConnectPacket").write(46).write("create").write(40).debug((Object)this.clientId).write(41);
        if (this.packetFlags != 0) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
        if ("MQTT".equals(this.protocolName)) {
            output = output.write(46).write("protocolName").write(40).debug((Object)this.protocolName).write(41);
        }
        if (this.protocolLevel != 4) {
            output = output.write(46).write("protocolLevel").write(40).debug((Object)this.protocolLevel).write(41);
        }
        if (this.keepAlive != 0) {
            output = output.write(46).write("keepAlive").write(40).debug((Object)this.keepAlive).write(41);
        }
        if (this.cleanSession()) {
            output = output.write(46).write("cleanSession").write(40).write("true").write(41);
        }
        if (this.willTopic != null) {
            output = output.write(46).write("willTopic").write(40).debug((Object)this.willTopic).write(41);
        }
        if (this.willMessage != null) {
            output = output.write(46).write("willMessage").write(40).debug((Object)this.willMessage).write(41);
        }
        if (this.willQoS().code != 0) {
            output = output.write(46).write("willQoS").write(40).debug((Object)this.willQoS()).write(41);
        }
        if (this.willRetain()) {
            output = output.write(46).write("willRetain").write(40).write("true").write(41);
        }
        if (this.username != null) {
            output = output.write(46).write("username").write(40).debug((Object)this.username).write(41);
        }
        if (this.password != null) {
            output = output.write(46).write("password").write(40).debug((Object)this.password).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttConnectPacket create(int packetFlags, String protocolName, int protocolLevel, int connectFlags, int keepAlive, String clientId, String willTopic, Data willMessage, String username, Data password) {
        return new MqttConnectPacket(packetFlags, protocolName, protocolLevel, connectFlags, keepAlive, clientId, willTopic, willMessage, username, password);
    }

    public static MqttConnectPacket create(String clientId) {
        return new MqttConnectPacket(0, "MQTT", 4, 2, 0, clientId, null, null, null, null);
    }
}

