/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.util.Murmur3;

public final class MqttDisconnectPacket
extends MqttPacket<Object>
implements Debug {
    final int packetFlags;
    private static int hashSeed;
    private static MqttDisconnectPacket packet;

    MqttDisconnectPacket(int packetFlags) {
        this.packetFlags = packetFlags;
    }

    @Override
    public int packetType() {
        return 14;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttDisconnectPacket packetFlags(int packetFlags) {
        return new MqttDisconnectPacket(packetFlags);
    }

    @Override
    int variableHeaderSize(MqttEncoder mqtt) {
        return 0;
    }

    @Override
    public Encoder<?, MqttDisconnectPacket> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.disconnectPacketEncoder(this);
    }

    @Override
    public Encoder<?, MqttDisconnectPacket> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodeDisconnectPacket(output, this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttDisconnectPacket) {
            MqttDisconnectPacket that = (MqttDisconnectPacket)other;
            return this.packetFlags == that.packetFlags;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttDisconnectPacket.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("MqttDisconnectPacket").write(46).write("packet").write(40).write(41);
        if (this.packetFlags != 0) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttDisconnectPacket packet() {
        if (packet == null) {
            packet = new MqttDisconnectPacket(0);
        }
        return packet;
    }

    public static MqttDisconnectPacket create(int packetFlags) {
        if (packetFlags == 0) {
            return MqttDisconnectPacket.packet();
        }
        return new MqttDisconnectPacket(packetFlags);
    }
}

