/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.util.Murmur3;

public final class MqttPingRespPacket
extends MqttPacket<Object>
implements Debug {
    final int packetFlags;
    private static int hashSeed;
    private static MqttPingRespPacket packet;

    MqttPingRespPacket(int packetFlags) {
        this.packetFlags = packetFlags;
    }

    @Override
    public int packetType() {
        return 13;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttPingRespPacket packetFlags(int packetFlags) {
        return new MqttPingRespPacket(packetFlags);
    }

    @Override
    int variableHeaderSize(MqttEncoder mqtt) {
        return 0;
    }

    @Override
    public Encoder<?, MqttPingRespPacket> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.pingRespPacketEncoder(this);
    }

    @Override
    public Encoder<?, MqttPingRespPacket> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodePingRespPacket(output, this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttPingRespPacket) {
            MqttPingRespPacket that = (MqttPingRespPacket)other;
            return this.packetFlags == that.packetFlags;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttPingRespPacket.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("MqttPingRespPacket").write(46).write("packet").write(40).write(41);
        if (this.packetFlags != 0) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttPingRespPacket packet() {
        if (packet == null) {
            packet = new MqttPingRespPacket(0);
        }
        return packet;
    }

    public static MqttPingRespPacket create(int packetFlags) {
        if (packetFlags == 0) {
            return MqttPingRespPacket.packet();
        }
        return new MqttPingRespPacket(packetFlags);
    }
}

