/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.util.Murmur3;

public final class MqttPubRelPacket
extends MqttPacket<Object>
implements Debug {
    final int packetFlags;
    final int packetId;
    private static int hashSeed;

    MqttPubRelPacket(int packetFlags, int packetId) {
        this.packetFlags = packetFlags;
        this.packetId = packetId;
    }

    @Override
    public int packetType() {
        return 6;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttPubRelPacket packetFlags(int packetFlags) {
        return new MqttPubRelPacket(packetFlags, this.packetId);
    }

    public int packetId() {
        return this.packetId;
    }

    public MqttPubRelPacket packetId(int packetId) {
        return new MqttPubRelPacket(this.packetFlags, packetId);
    }

    @Override
    int variableHeaderSize(MqttEncoder mqtt) {
        return 2;
    }

    @Override
    public Encoder<?, MqttPubRelPacket> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.pubRelPacketEncoder(this);
    }

    @Override
    public Encoder<?, MqttPubRelPacket> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodePubRelPacket(output, this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttPubRelPacket) {
            MqttPubRelPacket that = (MqttPubRelPacket)other;
            return this.packetFlags == that.packetFlags && this.packetId == that.packetId;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttPubRelPacket.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.packetId));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("MqttPubRelPacket").write(46).write("create").write(40).debug((Object)this.packetId).write(41);
        if (this.packetFlags != 2) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttPubRelPacket create(int packetFlags, int packetId) {
        return new MqttPubRelPacket(packetFlags, packetId);
    }

    public static MqttPubRelPacket create(int packetId) {
        return new MqttPubRelPacket(2, packetId);
    }
}

