/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import java.nio.ByteBuffer;
import swim.codec.Binary;
import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.codec.Utf8;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.mqtt.MqttQoS;
import swim.structure.Data;
import swim.util.Murmur3;

public final class MqttPublishPacket<T>
extends MqttPacket<T>
implements Debug {
    final int packetFlags;
    final String topicName;
    final int packetId;
    final T payloadValue;
    final Encoder<?, ?> payloadEncoder;
    final int payloadSize;
    private static int hashSeed;
    static final int RETAIN_FLAG = 1;
    static final int QOS_MASK = 6;
    static final int QOS_SHIFT = 1;
    static final int DUP_FLAG = 8;

    MqttPublishPacket(int packetFlags, String topicName, int packetId, T payloadValue, Encoder<?, ?> payloadEncoder, int payloadSize) {
        this.packetFlags = packetFlags;
        this.topicName = topicName;
        this.packetId = packetId;
        this.payloadValue = payloadValue;
        this.payloadEncoder = payloadEncoder;
        this.payloadSize = payloadSize;
    }

    @Override
    public int packetType() {
        return 3;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public boolean retain() {
        return (this.packetFlags & 1) != 0;
    }

    public MqttPublishPacket<T> retain(boolean retain) {
        int packetFlags = retain ? this.packetFlags | 1 : this.packetFlags & 0xFFFFFFFE;
        return new MqttPublishPacket<T>(packetFlags, this.topicName, this.packetId, this.payloadValue, this.payloadEncoder, this.payloadSize);
    }

    public MqttQoS qos() {
        return MqttQoS.from((this.packetFlags & 6) >>> 1);
    }

    public MqttPublishPacket<T> qos(MqttQoS qos) {
        int packetFlags = this.packetFlags & 0xFFFFFFF9 | qos.code << 1 & 6;
        return new MqttPublishPacket<T>(packetFlags, this.topicName, this.packetId, this.payloadValue, this.payloadEncoder, this.payloadSize);
    }

    public boolean dup() {
        return (this.packetFlags & 8) != 0;
    }

    public MqttPublishPacket<T> dup(boolean dup) {
        int packetFlags = dup ? this.packetFlags | 8 : this.packetFlags & 0xFFFFFFF7;
        return new MqttPublishPacket<T>(packetFlags, this.topicName, this.packetId, this.payloadValue, this.payloadEncoder, this.payloadSize);
    }

    public String topicName() {
        return this.topicName;
    }

    public MqttPublishPacket<T> topicName(String topicName) {
        return new MqttPublishPacket<T>(this.packetFlags, topicName, this.packetId, this.payloadValue, this.payloadEncoder, this.payloadSize);
    }

    public boolean hasPacketId() {
        return (this.packetFlags & 6) >>> 1 != 0;
    }

    public int packetId() {
        return this.packetId;
    }

    public MqttPublishPacket<T> packetId(int packetId) {
        return new MqttPublishPacket<T>(this.packetFlags, this.topicName, packetId, this.payloadValue, this.payloadEncoder, this.payloadSize);
    }

    public T payloadValue() {
        return this.payloadValue;
    }

    public <U> MqttPublishPacket<U> payloadValue(U payloadValue) {
        return new MqttPublishPacket<U>(this.packetFlags, this.topicName, this.packetId, payloadValue, this.payloadEncoder, this.payloadSize);
    }

    public Encoder<?, ?> payloadEncoder() {
        return this.payloadEncoder;
    }

    public int payloadSize() {
        return this.payloadSize;
    }

    public <U> MqttPublishPacket<U> payload(U payloadValue, Encoder<?, ?> payloadEncoder, int payloadSize) {
        return new MqttPublishPacket<U>(this.packetFlags, this.topicName, this.packetId, payloadValue, payloadEncoder, payloadSize);
    }

    public <U> MqttPublishPacket<U> payload(Encoder<?, ?> payloadEncoder, int payloadSize) {
        return new MqttPublishPacket<Object>(this.packetFlags, this.topicName, this.packetId, null, payloadEncoder, payloadSize);
    }

    public <U> MqttPublishPacket<U> payload(ByteBuffer payloadValue) {
        return new MqttPublishPacket<Object>(this.packetFlags, this.topicName, this.packetId, null, (Encoder<?, ?>)Binary.byteBufferWriter((ByteBuffer)payloadValue), payloadValue.remaining());
    }

    public MqttPublishPacket<Data> payload(Data payloadValue) {
        return new MqttPublishPacket<Data>(this.packetFlags, this.topicName, this.packetId, payloadValue.commit(), (Encoder<?, ?>)payloadValue.writer(), payloadValue.size());
    }

    public MqttPublishPacket<String> payload(String payloadValue) {
        Output output = Utf8.encodedOutput((Output)Binary.byteBufferOutput((int)payloadValue.length()));
        output = output.write(payloadValue);
        ByteBuffer payloadData = (ByteBuffer)output.bind();
        return new MqttPublishPacket<String>(this.packetFlags, this.topicName, this.packetId, payloadValue, (Encoder<?, ?>)Binary.byteBufferWriter((ByteBuffer)payloadData), payloadData.remaining());
    }

    @Override
    int variableHeaderSize(MqttEncoder mqtt) {
        int size = mqtt.sizeOfString(this.topicName);
        if (this.hasPacketId()) {
            size += 2;
        }
        return size += this.payloadSize;
    }

    @Override
    public Encoder<?, MqttPublishPacket<T>> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.publishPacketEncoder(this);
    }

    @Override
    public Encoder<?, MqttPublishPacket<T>> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodePublishPacket(output, this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttPublishPacket) {
            MqttPublishPacket that = (MqttPublishPacket)other;
            return this.packetFlags == that.packetFlags && this.topicName.equals(that.topicName) && this.packetId == that.packetId && (this.payloadValue == null ? that.payloadValue == null : this.payloadValue.equals(that.payloadValue)) && this.payloadSize == that.payloadSize;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttPublishPacket.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.topicName.hashCode()), (int)this.packetId), (int)Murmur3.hash(this.payloadValue)), (int)this.payloadSize));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("MqttPublishPacket").write(46).write("create").write(40).debug((Object)this.topicName).write(41);
        if (this.packetFlags != 0) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
        if (this.retain()) {
            output = output.write(46).write("retain").write(40).write("true").write(41);
        }
        if (this.qos().code != 0) {
            output = output.write(46).write("qos").write(40).debug((Object)this.qos()).write(41);
        }
        if (this.dup()) {
            output = output.write(46).write("dup").write(40).write("true").write(41);
        }
        if (this.hasPacketId()) {
            output = output.write(46).write("packetId").write(40).debug((Object)this.packetId).write(41);
        }
        if (this.payloadValue != null && this.payloadEncoder == Encoder.done() && this.payloadSize == 0) {
            output = output.write(46).write("payloadValue").write(40).debug(this.payloadValue).write(41);
        } else if (this.payloadValue != null || this.payloadEncoder != Encoder.done() || this.payloadSize != 0) {
            output = output.write(46).write("payload").write(40).debug(this.payloadValue).write(", ").debug(this.payloadEncoder).write(", ").debug((Object)this.payloadSize).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <T> MqttPublishPacket<T> create(int packetFlags, String topicName, int packetId, T payloadValue, Encoder<?, ?> payloadEncoder, int payloadSize) {
        return new MqttPublishPacket<T>(packetFlags, topicName, packetId, payloadValue, payloadEncoder, payloadSize);
    }

    public static <T> MqttPublishPacket<T> create(String topicName, int packetId, T payloadValue, Encoder<?, ?> payloadEncoder, int payloadSize) {
        return new MqttPublishPacket<T>(0, topicName, packetId, payloadValue, payloadEncoder, payloadSize);
    }

    public static <T> MqttPublishPacket<T> create(String topicName, T payloadValue, Encoder<?, ?> payloadEncoder, int payloadSize) {
        return new MqttPublishPacket<T>(0, topicName, 0, payloadValue, payloadEncoder, payloadSize);
    }

    public static MqttPublishPacket<Object> create(String topicName) {
        return new MqttPublishPacket<Object>(0, topicName, 0, null, Encoder.done(), 0);
    }
}

