/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Output;

public enum MqttQoS implements Debug
{
    AT_MOST_ONCE(0),
    AT_LEAST_ONCE(1),
    EXACTLY_ONCE(2);

    public final int code;

    private MqttQoS(int code) {
        this.code = code;
    }

    public boolean isAtMostOnce() {
        return this.code == 0;
    }

    public boolean isAtLeastOnce() {
        return this.code == 1;
    }

    public boolean isExactlyOnce() {
        return this.code == 2;
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("MqttQoS").write(46).write(this.name());
        return output;
    }

    public static MqttQoS from(int code) {
        switch (code) {
            case 0: {
                return AT_MOST_ONCE;
            }
            case 1: {
                return AT_LEAST_ONCE;
            }
            case 2: {
                return EXACTLY_ONCE;
            }
        }
        throw new IllegalArgumentException(Integer.toString(code));
    }
}

