/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.collections.FingerTrieSeq;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttSubscribePacket;
import swim.mqtt.MqttSubscription;

final class MqttSubscribePacketDecoder
extends Decoder<MqttSubscribePacket> {
    final MqttDecoder mqtt;
    final int packetFlags;
    final int packetId;
    final Decoder<MqttSubscription> subscriptionDecoder;
    final FingerTrieSeq<MqttSubscription> subscriptions;
    final int remaining;
    final int step;

    MqttSubscribePacketDecoder(MqttDecoder mqtt, int packetFlags, int packetId, Decoder<MqttSubscription> subscriptionDecoder, FingerTrieSeq<MqttSubscription> subscriptions, int remaining, int step) {
        this.mqtt = mqtt;
        this.packetFlags = packetFlags;
        this.remaining = remaining;
        this.packetId = packetId;
        this.subscriptionDecoder = subscriptionDecoder;
        this.subscriptions = subscriptions;
        this.step = step;
    }

    MqttSubscribePacketDecoder(MqttDecoder mqtt) {
        this(mqtt, 0, 0, null, (FingerTrieSeq<MqttSubscription>)FingerTrieSeq.empty(), 0, 1);
    }

    public Decoder<MqttSubscribePacket> feed(InputBuffer input) {
        return MqttSubscribePacketDecoder.decode(input, this.mqtt, this.packetFlags, this.packetId, this.subscriptionDecoder, this.subscriptions, this.remaining, this.step);
    }

    static Decoder<MqttSubscribePacket> decode(InputBuffer input, MqttDecoder mqtt, int packetFlags, int packetId, Decoder<MqttSubscription> subscriptionDecoder, FingerTrieSeq<MqttSubscription> subscriptions, int remaining, int step) {
        if (step == 1 && input.isCont()) {
            packetFlags = input.head() & 0xF;
            input = input.step();
            step = 2;
        }
        while (step >= 2 && step <= 5 && input.isCont()) {
            int b = input.head();
            input = input.step();
            remaining |= (b & 0x7F) << 7 * (step - 2);
            if ((b & 0x80) == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return Decoder.error((Throwable)new MqttException("packet length too long"));
        }
        if (step == 6 && remaining > 0 && input.isCont()) {
            packetId = input.head() << 8;
            input = input.step();
            --remaining;
            step = 7;
        }
        if (step == 7 && remaining > 0 && input.isCont()) {
            packetId |= input.head();
            input = input.step();
            step = --remaining > 0 ? 8 : 9;
        }
        while (step == 8 && remaining > 0 && input.isCont()) {
            int inputStart = input.index();
            int inputLimit = input.limit();
            int inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            boolean inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            subscriptionDecoder = subscriptionDecoder == null ? mqtt.decodeSubscription(input) : subscriptionDecoder.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (subscriptionDecoder.isDone()) {
                subscriptions = subscriptions.appended((Object)((MqttSubscription)subscriptionDecoder.bind()));
                subscriptionDecoder = null;
                if (remaining != 0) continue;
                step = 9;
                break;
            }
            if (!subscriptionDecoder.isError()) continue;
            return subscriptionDecoder.asError();
        }
        if (step == 9 && remaining == 0) {
            return Decoder.done((Object)mqtt.subscribePacket(packetFlags, packetId, subscriptions));
        }
        if (remaining < 0) {
            return Decoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (input.isDone()) {
            return Decoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return Decoder.error((Throwable)input.trap());
        }
        return new MqttSubscribePacketDecoder(mqtt, packetFlags, packetId, (Decoder<MqttSubscription>)subscriptionDecoder, (FingerTrieSeq<MqttSubscription>)subscriptions, remaining, step);
    }

    static Decoder<MqttSubscribePacket> decode(InputBuffer input, MqttDecoder mqtt) {
        return MqttSubscribePacketDecoder.decode(input, mqtt, 0, 0, null, (FingerTrieSeq<MqttSubscription>)FingerTrieSeq.empty(), 0, 1);
    }
}

