/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttSubscription;

final class MqttSubscriptionDecoder
extends Decoder<MqttSubscription> {
    final MqttDecoder mqtt;
    final Decoder<String> topicNameDecoder;
    final int step;

    MqttSubscriptionDecoder(MqttDecoder mqtt, Decoder<String> topicNameDecoder, int step) {
        this.mqtt = mqtt;
        this.topicNameDecoder = topicNameDecoder;
        this.step = step;
    }

    MqttSubscriptionDecoder(MqttDecoder mqtt) {
        this(mqtt, null, 1);
    }

    public Decoder<MqttSubscription> feed(InputBuffer input) {
        return MqttSubscriptionDecoder.decode(input, this.mqtt, this.topicNameDecoder, this.step);
    }

    static Decoder<MqttSubscription> decode(InputBuffer input, MqttDecoder mqtt, Decoder<String> topicNameDecoder, int step) {
        if (step == 1) {
            if ((topicNameDecoder = topicNameDecoder == null ? mqtt.decodeString(input) : topicNameDecoder.feed(input)).isDone()) {
                step = 2;
            } else if (topicNameDecoder.isError()) {
                return topicNameDecoder.asError();
            }
        }
        if (step == 2 && input.isCont()) {
            int flags = input.head();
            input = input.step();
            return Decoder.done((Object)mqtt.subscription((String)topicNameDecoder.bind(), flags));
        }
        if (input.isDone()) {
            return Decoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return Decoder.error((Throwable)input.trap());
        }
        return new MqttSubscriptionDecoder(mqtt, (Decoder<String>)topicNameDecoder, step);
    }

    static Decoder<MqttSubscription> decode(InputBuffer input, MqttDecoder mqtt) {
        return MqttSubscriptionDecoder.decode(input, mqtt, null, 1);
    }
}

