/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.mqtt.MqttConnAckPacket;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttException;

final class MqttConnAckPacketDecoder
extends Decoder<MqttConnAckPacket> {
    final MqttDecoder mqtt;
    final int packetFlags;
    final int connectFlags;
    final int connectCode;
    final int remaining;
    final int step;

    MqttConnAckPacketDecoder(MqttDecoder mqtt, int packetFlags, int connectFlags, int connectCode, int remaining, int step) {
        this.mqtt = mqtt;
        this.packetFlags = packetFlags;
        this.connectFlags = connectFlags;
        this.connectCode = connectCode;
        this.remaining = remaining;
        this.step = step;
    }

    MqttConnAckPacketDecoder(MqttDecoder mqtt) {
        this(mqtt, 0, 0, 0, 0, 1);
    }

    public Decoder<MqttConnAckPacket> feed(InputBuffer input) {
        return MqttConnAckPacketDecoder.decode(input, this.mqtt, this.packetFlags, this.connectFlags, this.connectCode, this.remaining, this.step);
    }

    static Decoder<MqttConnAckPacket> decode(InputBuffer input, MqttDecoder mqtt, int packetFlags, int connectFlags, int connectCode, int remaining, int step) {
        if (step == 1 && input.isCont()) {
            packetFlags = input.head() & 0xF;
            input = input.step();
            step = 2;
        }
        while (step >= 2 && step <= 5 && input.isCont()) {
            int b = input.head();
            input = input.step();
            remaining |= (b & 0x7F) << 7 * (step - 2);
            if ((b & 0x80) == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return Decoder.error((Throwable)new MqttException("packet length too long"));
        }
        if (step == 6 && remaining > 0 && input.isCont()) {
            connectFlags = input.head();
            input = input.step();
            --remaining;
            step = 7;
        }
        if (step == 7 && remaining > 0 && input.isCont()) {
            connectCode = input.head();
            input = input.step();
            --remaining;
            step = 8;
        }
        if (step == 8 && remaining == 0) {
            return Decoder.done((Object)mqtt.connAckPacket(packetFlags, connectFlags, connectCode));
        }
        if (remaining < 0) {
            return Decoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (input.isDone()) {
            return Decoder.error((Throwable)new DecoderException("incomplete"));
        }
        return new MqttConnAckPacketDecoder(mqtt, packetFlags, connectFlags, connectCode, remaining, step);
    }

    static Decoder<MqttConnAckPacket> decode(InputBuffer input, MqttDecoder mqtt) {
        return MqttConnAckPacketDecoder.decode(input, mqtt, 0, 0, 0, 0, 1);
    }
}

