/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttDisconnectPacket;
import swim.mqtt.MqttException;

final class MqttDisconnectPacketDecoder
extends Decoder<MqttDisconnectPacket> {
    final MqttDecoder mqtt;
    final int packetFlags;
    final int remaining;
    final int step;

    MqttDisconnectPacketDecoder(MqttDecoder mqtt, int packetFlags, int remaining, int step) {
        this.mqtt = mqtt;
        this.packetFlags = packetFlags;
        this.remaining = remaining;
        this.step = step;
    }

    MqttDisconnectPacketDecoder(MqttDecoder mqtt) {
        this(mqtt, 0, 0, 1);
    }

    public Decoder<MqttDisconnectPacket> feed(InputBuffer input) {
        return MqttDisconnectPacketDecoder.decode(input, this.mqtt, this.packetFlags, this.remaining, this.step);
    }

    static Decoder<MqttDisconnectPacket> decode(InputBuffer input, MqttDecoder mqtt, int packetFlags, int remaining, int step) {
        if (step == 1 && input.isCont()) {
            packetFlags = input.head() & 0xF;
            input = input.step();
            step = 2;
        }
        while (step >= 2 && step <= 5 && input.isCont()) {
            int b = input.head();
            input = input.step();
            remaining |= (b & 0x7F) << 7 * (step - 2);
            if ((b & 0x80) == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return Decoder.error((Throwable)new MqttException("packet length too long"));
        }
        if (step == 6 && remaining == 0) {
            return Decoder.done((Object)mqtt.disconnectPacket(packetFlags));
        }
        if (remaining < 0) {
            return Decoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (input.isDone()) {
            return Decoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return Decoder.error((Throwable)input.trap());
        }
        return new MqttDisconnectPacketDecoder(mqtt, packetFlags, remaining, step);
    }

    static Decoder<MqttDisconnectPacket> decode(InputBuffer input, MqttDecoder mqtt) {
        return MqttDisconnectPacketDecoder.decode(input, mqtt, 0, 0, 1);
    }
}

