/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttPingReqPacket;

final class MqttPingReqPacketEncoder
extends Encoder<Object, MqttPingReqPacket> {
    final MqttEncoder mqtt;
    final MqttPingReqPacket packet;
    final int length;
    final int remaining;
    final int step;

    MqttPingReqPacketEncoder(MqttEncoder mqtt, MqttPingReqPacket packet, int length, int remaining, int step) {
        this.mqtt = mqtt;
        this.packet = packet;
        this.length = length;
        this.remaining = remaining;
        this.step = step;
    }

    MqttPingReqPacketEncoder(MqttEncoder mqtt, MqttPingReqPacket packet) {
        this(mqtt, packet, 0, 0, 1);
    }

    public Encoder<Object, MqttPingReqPacket> pull(OutputBuffer<?> output) {
        return MqttPingReqPacketEncoder.encode(output, this.mqtt, this.packet, this.length, this.remaining, this.step);
    }

    static Encoder<Object, MqttPingReqPacket> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttPingReqPacket packet, int length, int remaining, int step) {
        if (step == 1 && output.isCont()) {
            remaining = length = packet.variableHeaderSize(mqtt);
            output = output.write(packet.packetType() << 4 | packet.packetFlags & 0xF);
            step = 2;
        }
        while (step >= 2 && step <= 5 && output.isCont()) {
            int b = length & 0x7F;
            if ((length >>>= 7) > 0) {
                b |= 0x80;
            }
            output = output.write(b);
            if (length == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return Encoder.error((Throwable)new MqttException("packet length too long: " + remaining));
        }
        if (step == 6 && remaining == 0) {
            return Encoder.done((Object)packet);
        }
        if (remaining < 0) {
            return Encoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (output.isDone()) {
            return Encoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return Encoder.error((Throwable)output.trap());
        }
        return new MqttPingReqPacketEncoder(mqtt, packet, length, remaining, step);
    }

    static Encoder<Object, MqttPingReqPacket> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttPingReqPacket packet) {
        return MqttPingReqPacketEncoder.encode(output, mqtt, packet, 0, 0, 1);
    }
}

