/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttPingRespPacket;

final class MqttPingRespPacketEncoder
extends Encoder<Object, MqttPingRespPacket> {
    final MqttEncoder mqtt;
    final MqttPingRespPacket packet;
    final int length;
    final int remaining;
    final int step;

    MqttPingRespPacketEncoder(MqttEncoder mqtt, MqttPingRespPacket packet, int length, int remaining, int step) {
        this.mqtt = mqtt;
        this.packet = packet;
        this.length = length;
        this.remaining = remaining;
        this.step = step;
    }

    MqttPingRespPacketEncoder(MqttEncoder mqtt, MqttPingRespPacket packet) {
        this(mqtt, packet, 0, 0, 1);
    }

    public Encoder<Object, MqttPingRespPacket> pull(OutputBuffer<?> output) {
        return MqttPingRespPacketEncoder.encode(output, this.mqtt, this.packet, this.length, this.remaining, this.step);
    }

    static Encoder<Object, MqttPingRespPacket> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttPingRespPacket packet, int length, int remaining, int step) {
        if (step == 1 && output.isCont()) {
            remaining = length = packet.variableHeaderSize(mqtt);
            output = output.write(packet.packetType() << 4 | packet.packetFlags & 0xF);
            step = 2;
        }
        while (step >= 2 && step <= 5 && output.isCont()) {
            int b = length & 0x7F;
            if ((length >>>= 7) > 0) {
                b |= 0x80;
            }
            output = output.write(b);
            if (length == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return Encoder.error((Throwable)new MqttException("packet length too long: " + remaining));
        }
        if (step == 6 && remaining == 0) {
            return Encoder.done((Object)packet);
        }
        if (remaining < 0) {
            return Encoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (output.isDone()) {
            return Encoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return Encoder.error((Throwable)output.trap());
        }
        return new MqttPingRespPacketEncoder(mqtt, packet, length, remaining, step);
    }

    static Encoder<Object, MqttPingRespPacket> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttPingRespPacket packet) {
        return MqttPingRespPacketEncoder.encode(output, mqtt, packet, 0, 0, 1);
    }
}

